/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util;

import com.cout970.magneticraft.api.steel.AttributeRegistry;
import com.cout970.magneticraft.api.steel.ISteelAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTHelper {
    public static final int END = 0;
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int INT = 3;
    public static final int LONG = 4;
    public static final int FLOAT = 5;
    public static final int DOUBLE = 6;
    public static final int BYTE_ARRAY = 7;
    public static final int STRING = 8;
    public static final int LIST = 9;
    public static final int COMPOUND = 10;
    public static final int INT_ARRAY = 11;
    public static final String STEEL_ATTRIBUTES = "steelAttributes";

    public static NBTTagList getSteelAttributes(ItemStack stack) {
        return stack.func_77978_p().func_150295_c(STEEL_ATTRIBUTES, 10);
    }

    public static Map<ISteelAttribute, Integer> getSteelAttributeMap(ItemStack stack) {
        NBTTagList list = NBTHelper.getSteelAttributes(stack);
        HashMap<ISteelAttribute, Integer> map = new HashMap<ISteelAttribute, Integer>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            int id = compound.func_74762_e("id");
            int value = compound.func_74762_e("value");
            ISteelAttribute attribute = AttributeRegistry.getAttribute(id);
            map.put(attribute, value);
        }
        return map;
    }

    public static void setAttributeMap(Map<ISteelAttribute, Integer> map, ItemStack stack) {
        NBTTagList list = new NBTTagList();
        for (ISteelAttribute attribute : map.keySet()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("id", AttributeRegistry.getAttributeID(attribute));
            compound.func_74768_a("value", map.get(attribute).intValue());
            list.func_74742_a((NBTBase)compound);
        }
        stack.func_77978_p().func_74782_a(STEEL_ATTRIBUTES, (NBTBase)list);
    }
}

