/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.part.compat.fmp;

import codechicken.lib.vec.Cuboid6;
import codechicken.microblock.CommonMicroblock;
import codechicken.microblock.CornerMicroblock;
import codechicken.microblock.EdgeMicroblock;
import codechicken.microblock.FaceMicroblock;
import codechicken.microblock.HollowMicroblock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import uk.co.qmunity.lib.part.IMicroblock;
import uk.co.qmunity.lib.part.MicroblockShape;
import uk.co.qmunity.lib.part.PartBase;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;
import uk.co.qmunity.lib.vec.Vec3dCube;

public class FMPMicroblock
extends PartBase
implements IMicroblock {
    private CommonMicroblock microblock;

    public FMPMicroblock(CommonMicroblock microblock) {
        this.microblock = microblock;
    }

    @Override
    public MicroblockShape getShape() {
        if (this.microblock instanceof HollowMicroblock) {
            return MicroblockShape.FACE_HOLLOW;
        }
        if (this.microblock instanceof FaceMicroblock) {
            return MicroblockShape.FACE;
        }
        if (this.microblock instanceof CornerMicroblock) {
            return MicroblockShape.CORNER;
        }
        if (this.microblock instanceof EdgeMicroblock) {
            return MicroblockShape.EDGE;
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.microblock.getSize();
    }

    @Override
    public int getPosition() {
        if (this.microblock instanceof FaceMicroblock || this.microblock instanceof HollowMicroblock) {
            return this.microblock.getShape();
        }
        return -1;
    }

    @Override
    public String getType() {
        return "fmpmicroblock";
    }

    @Override
    public ItemStack getItem() {
        return null;
    }

    @Override
    public boolean breakAndDrop(EntityPlayer player, QMovingObjectPosition mop) {
        return false;
    }

    @Override
    public World getWorld() {
        return this.microblock.world();
    }

    @Override
    public int getX() {
        return this.microblock.x();
    }

    @Override
    public int getY() {
        return this.microblock.y();
    }

    @Override
    public int getZ() {
        return this.microblock.z();
    }

    @Override
    public List<Vec3dCube> getOcclusionBoxes() {
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        for (Cuboid6 c : this.microblock.getSubParts()) {
            boxes.add(new Vec3dCube(c.toAABB()));
        }
        return boxes;
    }

    @Override
    public double getHardness(EntityPlayer player, QMovingObjectPosition mop) {
        return 0.0;
    }
}

