/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.raytrace;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.part.IPartSelectable;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class RayTracer {
    private static RayTracer instance = new RayTracer();
    public static double overrideReachDistance = -1.0;

    public static RayTracer instance() {
        return instance;
    }

    private RayTracer() {
    }

    public QMovingObjectPosition rayTraceCubes(IPartSelectable part, Vec3d start, Vec3d end) {
        try {
            QMovingObjectPosition mop = this.rayTraceCubes(part.getSelectionBoxes(), start, end, new Vec3i(part.getX(), part.getY(), part.getZ()));
            if (mop == null) {
                return null;
            }
            return new QMovingObjectPosition(mop, part, mop.getCube());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public QMovingObjectPosition rayTraceCubes(List<Vec3dCube> cubes, Vec3d start, Vec3d end, Vec3i blockPos) {
        Vec3d end_;
        if (cubes == null) {
            return null;
        }
        Vec3d start_ = start.clone().sub(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        QMovingObjectPosition mop = this.rayTraceCubes(cubes, start_, end_ = end.clone().sub(blockPos.getX(), blockPos.getY(), blockPos.getZ()));
        if (mop == null) {
            return null;
        }
        mop.field_72311_b += blockPos.getX();
        mop.field_72312_c += blockPos.getY();
        mop.field_72309_d += blockPos.getZ();
        mop.field_72307_f = mop.field_72307_f.func_72441_c((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        return mop;
    }

    public QMovingObjectPosition rayTraceCubes(List<Vec3dCube> cubes, Vec3d start, Vec3d end) {
        QMovingObjectPosition closest = null;
        double dist = Double.MAX_VALUE;
        for (Vec3dCube c : cubes) {
            double d;
            QMovingObjectPosition mop = this.rayTraceCube(c, start, end);
            if (mop == null || !((d = mop.distanceTo(start)) < dist)) continue;
            dist = d;
            closest = mop;
        }
        return closest;
    }

    public QMovingObjectPosition rayTraceCube(Vec3dCube cube, Vec3d start, Vec3d end) {
        Vec3d closest = null;
        double dist = Double.MAX_VALUE;
        ForgeDirection f = null;
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            double d;
            Vec3d v = this.rayTraceFace(cube, face, start, end);
            if (v == null || !((d = v.distanceTo(start)) < dist)) continue;
            dist = d;
            closest = v;
            f = face;
        }
        if (closest == null) {
            return null;
        }
        return new QMovingObjectPosition(new MovingObjectPosition(0, 0, 0, f.ordinal(), closest.toVec3()), cube);
    }

    private Vec3d rayTraceFace(Vec3dCube cube, ForgeDirection face, Vec3d start, Vec3d end) {
        Vec3d director = end.clone().sub(start).normalize();
        Vec3d normal = this.getNormal(face);
        Vec3d point = this.getPoint(cube, face).clone();
        if (normal.dot(director) == 0.0) {
            return null;
        }
        double t = (point.dot(normal) - start.dot(normal)) / director.dot(normal);
        double x = start.getX() + t * director.getX();
        double y = start.getY() + t * director.getY();
        double z = start.getZ() + t * director.getZ();
        Vec3d v = new Vec3d(x, y, z);
        Vec3dCube f = this.getFace(cube, face);
        if (normal.getX() != 0.0) {
            if (v.getY() < f.getMinY() || v.getY() > f.getMaxY() || v.getZ() < f.getMinZ() || v.getZ() > f.getMaxZ()) {
                return null;
            }
        } else if (normal.getY() != 0.0) {
            if (v.getX() < f.getMinX() || v.getX() > f.getMaxX() || v.getZ() < f.getMinZ() || v.getZ() > f.getMaxZ()) {
                return null;
            }
        } else if (normal.getZ() != 0.0) {
            if (v.getX() < f.getMinX() || v.getX() > f.getMaxX() || v.getY() < f.getMinY() || v.getY() > f.getMaxY()) {
                return null;
            }
        } else {
            return null;
        }
        return v;
    }

    private Vec3d getPoint(Vec3dCube cube, ForgeDirection face) {
        if (face.offsetX + face.offsetY + face.offsetZ < 0) {
            return cube.getMin();
        }
        return cube.getMax();
    }

    private Vec3dCube getFace(Vec3dCube cube, ForgeDirection face) {
        Vec3d min = cube.getMin().clone();
        Vec3d max = cube.getMax().clone();
        switch (face) {
            case DOWN: {
                max.setY(min.getY());
                break;
            }
            case UP: {
                min.setY(max.getY());
                break;
            }
            case WEST: {
                max.setX(min.getX());
                break;
            }
            case EAST: {
                min.setX(max.getX());
                break;
            }
            case NORTH: {
                max.setZ(min.getZ());
                break;
            }
            case SOUTH: {
                min.setZ(max.getZ());
                break;
            }
        }
        return new Vec3dCube(min, max);
    }

    private Vec3d getNormal(ForgeDirection face) {
        return new Vec3d(face.offsetX, face.offsetY, face.offsetZ);
    }

    private static double getBlockReachDistance_server(EntityPlayerMP player) {
        return player.field_71134_c.getBlockReachDistance();
    }

    @SideOnly(value=Side.CLIENT)
    private static double getBlockReachDistance_client() {
        return Minecraft.func_71410_x().field_71442_b.func_78757_d();
    }

    public static double getBlockReachDistance(EntityPlayer player) {
        if (overrideReachDistance > 0.0) {
            return overrideReachDistance;
        }
        return player.field_70170_p.field_72995_K ? RayTracer.getBlockReachDistance_client() : (player instanceof EntityPlayerMP ? RayTracer.getBlockReachDistance_server((EntityPlayerMP)player) : 5.0);
    }

    public static Vec3 getCorrectedHeadVector(EntityPlayer player) {
        Vec3d v = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        if (player.field_70170_p.field_72995_K) {
            v.add(0.0, player.func_70047_e() - player.getDefaultEyeHeight(), 0.0);
        } else {
            v.add(0.0, player.func_70047_e(), 0.0);
            if (player instanceof EntityPlayerMP && player.func_70093_af()) {
                v.sub(0.0, 0.08, 0.0);
            }
        }
        return v.toVec3();
    }

    public static Vec3d getStartVector(EntityPlayer player) {
        return new Vec3d(RayTracer.getCorrectedHeadVector(player));
    }

    public static Vec3d getEndVector(EntityPlayer player) {
        Vec3 headVec = RayTracer.getCorrectedHeadVector(player);
        Vec3 lookVec = player.func_70676_i(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        return new Vec3d(headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach));
    }
}

