/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.transform;

import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.vec.Quat;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;

public class Rotation
implements Transformation {
    private double x;
    private double y;
    private double z;
    private Vec3d center = Vec3d.center;
    private Quat r;

    public Rotation(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        Quat rx = new Quat(new Vec3d(1.0, 0.0, 0.0), Math.toRadians(x));
        Quat ry = new Quat(new Vec3d(0.0, 1.0, 0.0), Math.toRadians(y));
        Quat rz = new Quat(new Vec3d(0.0, 0.0, 1.0), Math.toRadians(z));
        this.r = rx.mul(ry.mul(rz));
    }

    public Rotation(double x, double y, double z, Vec3d center) {
        this(x, y, z);
        this.center = center;
    }

    public Rotation(ForgeDirection face) {
        switch (face) {
            case DOWN: {
                break;
            }
            case UP: {
                this.z = 180.0;
                break;
            }
            case WEST: {
                this.z = -90.0;
                break;
            }
            case EAST: {
                this.z = 90.0;
                break;
            }
            case NORTH: {
                this.x = 90.0;
                break;
            }
            case SOUTH: {
                this.x = -90.0;
                break;
            }
        }
        Quat rx = new Quat(new Vec3d(1.0, 0.0, 0.0), Math.toRadians(this.x));
        Quat ry = new Quat(new Vec3d(0.0, 1.0, 0.0), Math.toRadians(this.y));
        Quat rz = new Quat(new Vec3d(0.0, 0.0, 1.0), Math.toRadians(this.z));
        this.r = rx.mul(ry.mul(rz));
    }

    public Rotation(ForgeDirection face, Vec3d center) {
        this(face);
        this.center = center;
    }

    @Override
    public Vec3d apply(Vec3d point) {
        point = point.clone();
        point.sub(this.center);
        point.rotate(this.r);
        point.add(this.center);
        return point;
    }

    @Override
    public Vec3dCube apply(Vec3dCube cube) {
        return new Vec3dCube(this.apply(cube.getMin()), this.apply(cube.getMax()));
    }
}

