/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.vec;

import uk.co.qmunity.lib.vec.Vec3d;

public class Quat {
    private double x;
    private double y;
    private double z;
    private double w;

    public Quat(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quat(Vec3d axis, double angle) {
        double sinHalfAngle = Math.sin(angle / 2.0);
        this.x = axis.getX() * sinHalfAngle;
        this.y = axis.getY() * sinHalfAngle;
        this.z = axis.getZ() * sinHalfAngle;
        this.w = Math.cos(angle / 2.0);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public Quat normalize() {
        double len = this.length();
        this.x /= len;
        this.y /= len;
        this.z /= len;
        this.w /= len;
        return this;
    }

    public Quat conjugate() {
        return new Quat(-this.x, -this.y, -this.z, this.w);
    }

    public Quat mul(Quat r) {
        double w_ = this.w * r.getW() - this.x * r.getX() - this.y * r.getY() - this.z * r.getZ();
        double x_ = this.x * r.getW() + this.w * r.getX() + this.y * r.getZ() - this.z * r.getY();
        double y_ = this.y * r.getW() + this.w * r.getY() + this.z * r.getX() - this.x * r.getZ();
        double z_ = this.z * r.getW() + this.w * r.getZ() + this.x * r.getY() - this.y * r.getX();
        return new Quat(x_, y_, z_, w_);
    }

    public Vec3d mul(Vec3d v) {
        double k0 = this.w * this.w - 0.5;
        double k1 = v.x * this.x;
        k1 += v.y * this.y;
        double rx = v.x * k0 + this.x * (k1 += v.z * this.z);
        double ry = v.y * k0 + this.y * k1;
        double rz = v.z * k0 + this.z * k1;
        rx += this.w * (this.y * v.z - this.z * v.y);
        ry += this.w * (this.z * v.x - this.x * v.z);
        rz += this.w * (this.x * v.y - this.y * v.x);
        rx += rx;
        ry += ry;
        rz += rz;
        return new Vec3d(rx, ry, rz);
    }
}

