/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.vec;

import java.awt.Rectangle;
import uk.co.qmunity.lib.vec.Vec2d;
import uk.co.qmunity.lib.vec.Vec3dCube;

public class Vec2dRect {
    private Vec2d min;
    private Vec2d max;

    public Vec2dRect(Vec2d a, Vec2d b) {
        double x1 = Math.min(a.getX(), b.getX());
        double y1 = Math.min(a.getY(), b.getY());
        double x2 = Math.max(a.getX(), b.getX());
        double y2 = Math.max(a.getY(), b.getY());
        this.min = new Vec2d(x1, y1);
        this.max = new Vec2d(x2, y2);
    }

    public Vec2dRect(double x1, double y1, double x2, double y2) {
        this.min = new Vec2d(x1, y1);
        this.max = new Vec2d(x2, y2);
    }

    public Vec2dRect(Rectangle rect) {
        this(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
    }

    public Vec2d getMin() {
        return this.min;
    }

    public Vec2d getMax() {
        return this.max;
    }

    public double getMinX() {
        return this.min.getX();
    }

    public double getMinY() {
        return this.min.getY();
    }

    public double getMaxX() {
        return this.max.getX();
    }

    public double getMaxY() {
        return this.max.getY();
    }

    public Vec2d getCenter() {
        return this.getMin().clone().add(this.getMax()).div(2.0, 2.0);
    }

    public Vec2dRect rotate(double angle, Vec2d center) {
        this.min = this.min.clone().sub(center).rotate(angle).add(center);
        this.max = this.max.clone().sub(center).rotate(angle).add(center);
        return this;
    }

    public Vec2dRect clone() {
        return new Vec2dRect(this.min, this.max);
    }

    public Vec3dCube extrude(double height) {
        return new Vec3dCube(this.getMinX(), 0.0, this.getMinY(), this.getMaxX(), height, this.getMaxY());
    }
}

