/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.vec;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.misc.Pair;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.transform.Translation;
import uk.co.qmunity.lib.vec.Vec2dRect;
import uk.co.qmunity.lib.vec.Vec3d;

public class Vec3dCube {
    private Vec3d min;
    private Vec3d max;
    private IPart part;
    private Object data;

    public Vec3dCube(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this(minX, minY, minZ, maxX, maxY, maxZ, (World)null);
    }

    public Vec3dCube(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, IPart part) {
        this(minX, minY, minZ, maxX, maxY, maxZ, part.getWorld());
        this.part = part;
    }

    public Vec3dCube(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, World world) {
        this(new Vec3d(minX, minY, minZ, world), new Vec3d(maxX, maxY, maxZ, world));
    }

    public Vec3dCube(Vec3d a, Vec3d b) {
        World w = a.getWorld();
        if (w == null) {
            w = b.getWorld();
        }
        this.min = a;
        this.max = b;
        this.fix();
    }

    public Vec3dCube(Vec3d a, Vec3d b, IPart part) {
        this(a, b);
        this.part = part;
    }

    public Vec3dCube(AxisAlignedBB aabb) {
        this(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public Vec3d getMin() {
        return this.min;
    }

    public Vec3d getMax() {
        return this.max;
    }

    public Vec3d getCenter() {
        return new Vec3d((this.getMinX() + this.getMaxX()) / 2.0, (this.getMinY() + this.getMaxY()) / 2.0, (this.getMinZ() + this.getMaxZ()) / 2.0, this.getMin().getWorld());
    }

    public double getMinX() {
        return this.min.getX();
    }

    public double getMinY() {
        return this.min.getY();
    }

    public double getMinZ() {
        return this.min.getZ();
    }

    public double getMaxX() {
        return this.max.getX();
    }

    public double getMaxY() {
        return this.max.getY();
    }

    public double getMaxZ() {
        return this.max.getZ();
    }

    public IPart getPart() {
        return this.part;
    }

    public void setPart(IPart p) {
        this.part = p;
    }

    public AxisAlignedBB toAABB() {
        return AxisAlignedBB.func_72330_a((double)this.getMinX(), (double)this.getMinY(), (double)this.getMinZ(), (double)this.getMaxX(), (double)this.getMaxY(), (double)this.getMaxZ());
    }

    public Vec3dCube clone() {
        return new Vec3dCube(this.min.clone(), this.max.clone(), this.part);
    }

    public Vec3dCube expand(double size) {
        this.min.sub(size, size, size);
        this.max.add(size, size, size);
        return this;
    }

    public Vec3dCube fix() {
        Vec3d a = this.min.clone();
        Vec3d b = this.max.clone();
        double minX = Math.min(a.getX(), b.getX());
        double minY = Math.min(a.getY(), b.getY());
        double minZ = Math.min(a.getZ(), b.getZ());
        double maxX = Math.max(a.getX(), b.getX());
        double maxY = Math.max(a.getY(), b.getY());
        double maxZ = Math.max(a.getZ(), b.getZ());
        this.min = new Vec3d(minX, minY, minZ, a.w);
        this.max = new Vec3d(maxX, maxY, maxZ, b.w);
        return this;
    }

    public Vec3dCube rotate(int x, int y, int z, Vec3d center) {
        this.min.sub(center).rotate(x, y, z).add(center);
        this.max.sub(center).rotate(x, y, z).add(center);
        double mul = 1.0E7;
        this.fix();
        this.min.setX((double)Math.round(this.min.getX() * mul) / mul);
        this.min.setY((double)Math.round(this.min.getY() * mul) / mul);
        this.min.setZ((double)Math.round(this.min.getZ() * mul) / mul);
        this.max.setX((double)Math.round(this.max.getX() * mul) / mul);
        this.max.setY((double)Math.round(this.max.getY() * mul) / mul);
        this.max.setZ((double)Math.round(this.max.getZ() * mul) / mul);
        return this;
    }

    public Vec3dCube rotate(ForgeDirection face, Vec3d center) {
        switch (face) {
            case DOWN: {
                return this;
            }
            case UP: {
                return this.rotate(0, 0, 180, center);
            }
            case WEST: {
                return this.rotate(0, 0, -90, center);
            }
            case EAST: {
                return this.rotate(0, 0, 90, center);
            }
            case NORTH: {
                return this.rotate(90, 0, 0, center);
            }
            case SOUTH: {
                return this.rotate(-90, 0, 0, center);
            }
        }
        return this;
    }

    public Vec3dCube add(double x, double y, double z) {
        this.min.add(x, y, z);
        this.max.add(x, y, z);
        return this;
    }

    public static final Vec3dCube merge(List<Vec3dCube> cubes) {
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minz = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double maxy = Double.MIN_VALUE;
        double maxz = Double.MIN_VALUE;
        for (Vec3dCube c : cubes) {
            minx = Math.min(minx, c.getMinX());
            miny = Math.min(miny, c.getMinY());
            minz = Math.min(minz, c.getMinZ());
            maxx = Math.max(maxx, c.getMaxX());
            maxy = Math.max(maxy, c.getMaxY());
            maxz = Math.max(maxz, c.getMaxZ());
        }
        if (cubes.size() == 0) {
            return new Vec3dCube(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return new Vec3dCube(minx, miny, minz, maxx, maxy, maxz);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vec3dCube)) {
            return false;
        }
        Vec3dCube other = (Vec3dCube)o;
        return other.min.equals(this.min) && other.max.equals(this.max) && other.part == this.part;
    }

    public int hashCode() {
        return this.min.hashCode() << 8 + this.max.hashCode();
    }

    public Vec2dRect getFace(ForgeDirection face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return new Vec2dRect(this.getMinX(), this.getMinZ(), this.getMaxX(), this.getMaxZ());
            }
            case WEST: 
            case EAST: {
                return new Vec2dRect(this.getMinY(), this.getMinZ(), this.getMaxY(), this.getMaxZ());
            }
            case NORTH: 
            case SOUTH: {
                return new Vec2dRect(this.getMinX(), this.getMinY(), this.getMaxX(), this.getMaxY());
            }
        }
        return null;
    }

    public Vec3dCube transform(Transformation transformation) {
        return transformation.apply(this);
    }

    public boolean occlusionTest(Vec3dCube cube) {
        return !this.toAABB().func_72326_a(cube.toAABB());
    }

    public List<Pair<Pair<Vec3dCube, Translation>, boolean[]>> splitInto1x1() {
        ArrayList<Pair<Pair<Vec3dCube, Translation>, boolean[]>> cubes = new ArrayList<Pair<Pair<Vec3dCube, Translation>, boolean[]>>();
        int minx = (int)Math.floor(this.getMinX());
        int miny = (int)Math.floor(this.getMinY());
        int minz = (int)Math.floor(this.getMinZ());
        int maxx = (int)Math.ceil(this.getMaxX());
        int maxy = (int)Math.ceil(this.getMaxY());
        int maxz = (int)Math.ceil(this.getMaxZ());
        for (int x = minx; x < maxx; ++x) {
            for (int y = miny; y < maxy; ++y) {
                for (int z = minz; z < maxz; ++z) {
                    Translation t = new Translation(x, y, z);
                    Vec3dCube cube = new Vec3dCube(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                    boolean[] sides = new boolean[6];
                    if (x == minx) {
                        cube.getMin().setX(this.getMinX() - (double)minx);
                        sides[4] = true;
                    }
                    if (y == miny) {
                        cube.getMin().setY(this.getMinY() - (double)miny);
                        sides[0] = true;
                    }
                    if (z == minz) {
                        cube.getMin().setZ(this.getMinZ() - (double)minz);
                        sides[2] = true;
                    }
                    if (x == maxx - 1) {
                        cube.getMax().setX(this.getMaxX() - (double)(maxx - 1));
                        sides[5] = true;
                    }
                    if (y == maxy - 1) {
                        cube.getMax().setY(this.getMaxY() - (double)(maxy - 1));
                        sides[1] = true;
                    }
                    if (z == maxz - 1) {
                        cube.getMax().setZ(this.getMaxZ() - (double)(maxz - 1));
                        sides[3] = true;
                    }
                    cube.fix();
                    cubes.add(new Pair<Pair<Vec3dCube, Translation>, boolean[]>(new Pair<Vec3dCube, Translation>(cube, t), sides));
                }
            }
        }
        return cubes;
    }

    public Vec3dCube setData(Object data) {
        this.data = data;
        return this;
    }

    public Object getData() {
        return this.data;
    }
}

