/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.api.util.cache;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import tehnut.resourceful.crops.api.util.cache.WorldCache;

public class PermanentCache<I>
extends WorldCache<I> {
    private static final List<PermanentCache<?>> allCaches = Lists.newArrayList();

    public PermanentCache(String ident) {
        super(ident);
        this.loadData(this.getSaveFile());
    }

    @Override
    protected File getSaveFile() {
        return new File("saves", this.ident + ".dat");
    }

    @Override
    protected void blockOldIDs() {
        if (!this.objToName.isEmpty()) {
            super.blockOldIDs();
        }
    }

    @Override
    protected void mergeNewIDs() {
        if (!this.objToName.isEmpty()) {
            super.mergeNewIDs();
        }
    }

    @Override
    public void addObject(I object, String name) {
        super.addObject(object, name);
        this.setID(name);
    }

    public static void saveCaches() {
        for (PermanentCache<?> c : allCaches) {
            c.saveData(c.getSaveFile());
        }
    }
}

