/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.command;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.base.SeedBuilder;
import tehnut.resourceful.crops.util.Utils;

public class CommandCreateSeed
extends CommandBase {
    public static ArrayList<Seed> commandList = new ArrayList();

    public String getCommandName() {
        return "createSeed";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "/" + this.getCommandName();
    }

    public void processCommand(ICommandSender sender, String[] args) {
        World world = sender.getEntityWorld();
        EntityPlayer player = world.getPlayerEntityByName(sender.getCommandSenderName());
        if (args.length > 0 && args[0].equals("help")) {
            for (int i = 0; i < 4; ++i) {
                sender.addChatMessage((IChatComponent)new ChatComponentText(StatCollector.translateToLocal((String)("chat.ResourcefulCrops.seeds.create.help." + i))));
            }
            return;
        }
        if (player.getHeldItem() != null) {
            ItemStack stack = player.getHeldItem();
            SeedBuilder builder = new SeedBuilder();
            String name = stack.getDisplayName();
            int tier = 1;
            int amount = 1;
            Color color = Color.CYAN;
            for (String arg : args) {
                if (arg.startsWith("name") && arg.contains(":")) {
                    name = arg.split(":")[1].replace("_", " ");
                }
                if (arg.startsWith("tier") && arg.contains(":")) {
                    tier = CommandCreateSeed.parseIntBounded((ICommandSender)sender, (String)arg.split(":")[1], (int)1, (int)4);
                }
                if (arg.startsWith("amount") && arg.contains(":")) {
                    amount = CommandCreateSeed.parseIntBounded((ICommandSender)sender, (String)arg.split(":")[1], (int)1, (int)64);
                }
                if (!arg.startsWith("color") || !arg.contains(":")) continue;
                try {
                    String colorString = arg.split(":")[1];
                    if (!colorString.startsWith("#")) {
                        colorString = "#" + colorString;
                    }
                    color = Color.decode(colorString);
                }
                catch (NumberFormatException e) {
                    sender.addChatMessage((IChatComponent)new ChatComponentText(StatCollector.translateToLocalFormatted((String)"chat.ResourcefulCrops.seeds.create.nfe", (Object[])new Object[]{"Color"})));
                }
            }
            builder.setName(name);
            builder.setTier(tier);
            builder.setAmount(amount);
            builder.setInput(Utils.itemStackToString(new ItemStack(stack.getItem(), 1, stack.getItemDamage())));
            builder.setOutput(stack);
            builder.setColor(color);
            commandList.add(builder.build());
            sender.addChatMessage((IChatComponent)new ChatComponentText(StatCollector.translateToLocalFormatted((String)"chat.ResourcefulCrops.seeds.create", (Object[])new Object[]{name})));
        } else {
            sender.addChatMessage((IChatComponent)new ChatComponentText(StatCollector.translateToLocal((String)"chat.ResourcefulCrops.seeds.create.empty")));
        }
    }

    public int getRequiredPermissionLevel() {
        return 0;
    }

    public static ArrayList<Seed> getCommandList() {
        return new ArrayList<Seed>(commandList);
    }
}

