/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import tehnut.resourceful.crops.ResourcefulCrops;
import tehnut.resourceful.crops.api.ModInformation;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.registry.SeedRegistry;
import tehnut.resourceful.crops.registry.BlockRegistry;
import tehnut.resourceful.crops.tile.TileRCrop;
import tehnut.resourceful.crops.util.Utils;

public class ItemSeed
extends Item
implements IPlantable {
    public ItemSeed() {
        this.setUnlocalizedName("ResourcefulCrops.seed");
        this.setTextureName(ModInformation.TEXLOC + "seed_base");
        this.setCreativeTab(ResourcefulCrops.tabResourcefulCrops);
        this.setHasSubtypes(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tabs, List list) {
        for (Seed seed : SeedRegistry.getSeedList()) {
            list.add(new ItemStack((Item)this, 1, SeedRegistry.getIndexOf(seed)));
        }
        if (SeedRegistry.isEmpty()) {
            list.add(Utils.getInvalidSeed(this));
        }
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Seed seed;
        Block placed = world.getBlock(x, y, z);
        if (this.isSoil(world, x, y, z, placed, seed = SeedRegistry.getSeed(Utils.getItemDamage(stack))) && ForgeDirection.getOrientation((int)side) == ForgeDirection.UP && Utils.isValidSeed(Utils.getItemDamage(stack)) && world.isAirBlock(x, y + 1, z)) {
            world.setBlock(x, y + 1, z, BlockRegistry.crop);
            ((TileRCrop)world.getTileEntity(x, y + 1, z)).setSeedName(seed.getName());
            if (!player.capabilities.isCreativeMode) {
                player.inventory.decrStackSize(player.inventory.currentItem, 1);
            }
            return true;
        }
        return false;
    }

    public boolean isSoil(World world, int x, int y, int z, Block block, Seed seed) {
        return !seed.getNether() && block.canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)this) || seed.getNether() && world.getBlock(x, y, z) == Blocks.soul_sand;
    }

    @SideOnly(value=Side.CLIENT)
    public String getItemStackDisplayName(ItemStack stack) {
        if (Utils.isValidSeed(Utils.getItemDamage(stack))) {
            return String.format(StatCollector.translateToLocal((String)this.getUnlocalizedName()), StatCollector.translateToLocal((String)SeedRegistry.getSeed(Utils.getItemDamage(stack)).getName()));
        }
        return String.format(StatCollector.translateToLocal((String)this.getUnlocalizedName()), StatCollector.translateToLocal((String)"info.ResourcefulCrops.dead"));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        if (!Utils.isValidSeed(Utils.getItemDamage(stack))) {
            list.add(EnumChatFormatting.RED + StatCollector.translateToLocal((String)"info.ResourcefulCrops.warn"));
        } else {
            list.add(String.format(StatCollector.translateToLocal((String)"info.ResourcefulCrops.tier"), SeedRegistry.getSeed(Utils.getItemDamage(stack)).getTier()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int pass) {
        if (pass == 1 && Utils.isValidSeed(Utils.getItemDamage(stack))) {
            return SeedRegistry.getSeed(Utils.getItemDamage(stack)).getColor().getRGB();
        }
        return super.getColorFromItemStack(stack, pass);
    }

    public int getRenderPasses(int metadata) {
        return this.requiresMultipleRenderPasses() ? 2 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return BlockRegistry.crop;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return 0;
    }
}

