/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.util;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.registry.SeedRegistry;
import tehnut.resourceful.crops.api.util.BlockStack;
import tehnut.resourceful.crops.util.helper.LogHelper;

public class Utils {
    public static ItemStack parseItemStack(String stackString, boolean input) {
        if (stackString == null) {
            return null;
        }
        if (stackString.contains(":")) {
            String[] nameInfo = stackString.split(":");
            String name = nameInfo[0] + ":" + nameInfo[1];
            String[] stackInfo = nameInfo[2].split("#");
            int meta = Integer.parseInt(stackInfo[0]);
            int amount = Integer.parseInt(stackInfo[1]);
            return new ItemStack((Item)GameData.getItemRegistry().getObject(name), amount, meta);
        }
        if (stackString.equals("null")) {
            return null;
        }
        if (!input) {
            String[] stackInfo = stackString.split("#");
            ItemStack oreStack = (ItemStack)OreDictionary.getOres((String)stackInfo[0]).get(0);
            int amount = Integer.parseInt(stackInfo[1]);
            return new ItemStack(oreStack.getItem(), amount, oreStack.getItemDamage());
        }
        return null;
    }

    public static String itemStackToString(ItemStack stack) {
        if (stack != null) {
            return GameData.getItemRegistry().getNameForObject((Object)stack.getItem()) + ":" + stack.getItemDamage() + "#" + stack.stackSize;
        }
        return "null";
    }

    public static ItemStack getInvalidSeed(Item item) {
        return new ItemStack(item, 1, Short.MAX_VALUE);
    }

    public static int getItemDamage(ItemStack stack) {
        return stack.getItemDamage();
    }

    public static boolean isValidSeed(int seedIndex) {
        return SeedRegistry.getSeed(seedIndex) != null;
    }

    public static boolean isValidSeed(String seedName) {
        return SeedRegistry.getSeed(seedName) != null;
    }

    public static boolean isValidSeed(Seed seed) {
        return SeedRegistry.getSeedList().contains(seed);
    }

    public static void playBlockBreakAnim(World world, int x, int y, int z, BlockStack blockStack) {
        world.playAuxSFX(2001, x, y, z, Block.getIdFromBlock((Block)blockStack.getBlock()) + (blockStack.getMeta() << 12));
    }

    public static void registerCompat(Class clazz, String modid) {
        if (Loader.isModLoaded((String)modid)) {
            try {
                Class.forName(clazz.getCanonicalName());
            }
            catch (ClassNotFoundException e) {
                LogHelper.error("Could not find compatibility class for mod { " + modid + " }. Please report this.");
            }
        }
    }
}

