/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import tehnut.resourceful.crops.ResourcefulCrops;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.registry.SeedRegistry;
import tehnut.resourceful.crops.block.BlockRCrop;
import tehnut.resourceful.crops.tile.TileRCrop;
import tehnut.resourceful.crops.util.Utils;

public class RenderRCrop
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        renderer.setOverrideBlockTexture(block.getIcon(0, 0));
        renderer.renderCrossedSquares(Blocks.stone, 0, 0, 0);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        String seedName;
        int meta = world.getBlockMetadata(x, y, z);
        IIcon blockIcon = ((BlockRCrop)block).cropIcons[meta];
        float renderY = (float)y - 0.06f;
        TileEntity cropTile = world.getTileEntity(x, y, z);
        Tessellator tessellator = Tessellator.instance;
        Color cleared = new Color(0xFFFFFF);
        renderer.setOverrideBlockTexture(blockIcon);
        tessellator.setColorRGBA(cleared.getRed(), cleared.getGreen(), cleared.getBlue(), cleared.getAlpha());
        tessellator.setBrightness(block.getMixedBrightnessForBlock(world, x, y, z));
        renderer.drawCrossedSquares(blockIcon, (double)x, (double)renderY, (double)z, 1.0f);
        renderer.clearOverrideBlockTexture();
        if (cropTile instanceof TileRCrop && Utils.isValidSeed(seedName = ((TileRCrop)cropTile).getSeedName())) {
            Seed seed = SeedRegistry.getSeed(seedName);
            IIcon icon = ((BlockRCrop)block).cropOverlay[meta];
            tessellator.setColorRGBA(seed.getColor().getRed(), seed.getColor().getGreen(), seed.getColor().getBlue(), seed.getColor().getAlpha());
            switch (meta) {
                case 6: {
                    renderer.drawCrossedSquares(icon, (double)x, (double)(renderY + 0.0625f), (double)z, 1.0f);
                    break;
                }
                case 7: {
                    renderer.drawCrossedSquares(icon, (double)x, (double)(renderY + 0.125f), (double)z, 1.0f);
                    break;
                }
                default: {
                    renderer.drawCrossedSquares(icon, (double)x, (double)renderY, (double)z, 1.0f);
                }
            }
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return ResourcefulCrops.renderIDCrop;
    }
}

