/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.util;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import tehnut.resourceful.crops.api.base.Compat;
import tehnut.resourceful.crops.api.base.CompatBuilder;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.base.SeedBuilder;
import tehnut.resourceful.crops.api.compat.CompatibilitySeed;
import tehnut.resourceful.crops.api.registry.SeedRegistry;
import tehnut.resourceful.crops.api.util.BlockStack;
import tehnut.resourceful.crops.api.util.helper.ItemHelper;
import tehnut.resourceful.crops.util.helper.LogHelper;
import tehnut.resourceful.crops.util.serialization.SeedCreator;

public class StartupUtils {
    private static List<Seed> defaultSeeds = new ArrayList<Seed>();

    public static void initDefaults() {
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Inky", 1, 4, "dyeBlack", "dyeBlack#8", new Color(22, 22, 22), StartupUtils.getCompat(30)), "dyeBlack");
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Fleshy", 1, 4, ItemHelper.getItemString(Items.field_151078_bh), ItemHelper.getItemString(Items.field_151078_bh, 0, 8), new Color(255, 160, 136), StartupUtils.getCompat(30)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Feathery", 1, 4, ItemHelper.getItemString(Items.field_151008_G), ItemHelper.getItemString(Items.field_151008_G, 0, 8), new Color(208, 203, 199), StartupUtils.getCompat(30)));
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Tin", 2, 4, "ingotTin", "ingotTin#4", new Color(135, 154, 168)), "ingotTin");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Copper", 2, 4, "ingotCopper", "ingotCopper#4", new Color(204, 102, 51)), "ingotCopper");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Aluminum", 2, 4, "ingotAluminum", "ingotAluminum#4", new Color(198, 206, 130)), "ingotAluminum");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Zinc", 2, 4, "ingotZinc", "ingotZinc#4", new Color(192, 176, 182)), "ingotZinc");
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Coal", 2, 4, ItemHelper.getItemString(Items.field_151044_h), new ItemStack(Items.field_151044_h, 4), new Color(45, 44, 47)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Charcoal", 2, 4, ItemHelper.getItemString(Items.field_151044_h, 1), new ItemStack(Items.field_151044_h, 4, 1), new Color(45, 44, 47)));
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Saltpeter", 2, 4, "dustSaltpeter", "dustSaltpeter#8", new Color(182, 197, 212)), "dustSaltpeter");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Salt", 2, 4, "dustSalt", "dustSalt#8", new Color(182, 197, 212)), "dustSalt");
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Leathery", 2, 4, ItemHelper.getItemString(Items.field_151116_aA), new ItemStack(Items.field_151116_aA, 4), new Color(255, 68, 17)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Stringy", 2, 4, ItemHelper.getItemString(Items.field_151007_F), new ItemStack(Items.field_151007_F, 8), new Color(241, 255, 210)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Boney", 2, 4, ItemHelper.getItemString(Items.field_151103_aS), new ItemStack(Items.field_151103_aS, 4), new Color(255, 240, 205)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Slimey", 2, 4, ItemHelper.getItemString(Items.field_151123_aH), new ItemStack(Items.field_151123_aH, 4), new Color(62, 255, 119)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Blaze", 3, 4, ItemHelper.getItemString(Items.field_151072_bj), new ItemStack(Items.field_151072_bj, 2), new Color(255, 215, 66)));
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Iron", 3, 4, "ingotIron", "ingotIron#4", new Color(159, 156, 160)), "ingotIron");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Gold", 3, 4, "ingotGold", "ingotGold#4", new Color(255, 255, 0)), "ingotGold");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Lead", 3, 4, "ingotLead", "ingotLead#4", new Color(102, 102, 153)), "ingotLead");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Silver", 3, 4, "ingotSilver", "ingotSilver#4", new Color(187, 189, 184)), "ingotSilver");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Nickel", 3, 4, "ingotNickel", "ingotNickel#4", new Color(204, 204, 204)), "ingotNickel");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Mithril", 3, 4, "ingotMithril", "ingotMithril#4", new Color(146, 164, 208)), "ingotMithril");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Osmium", 3, 4, "ingotOsmium", "ingotOsmium#4", new Color(68, 60, 190)), "ingotOsmium");
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Ender", 3, 4, ItemHelper.getItemString(Items.field_151079_bi), new ItemStack(Items.field_151079_bi, 2), new Color(72, 100, 97)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Teary", 3, 4, ItemHelper.getItemString(Items.field_151073_bk), new ItemStack(Items.field_151073_bk, 4), new Color(212, 255, 241)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Creepy", 3, 4, ItemHelper.getItemString(Items.field_151016_H), new ItemStack(Items.field_151016_H, 8), new Color(0, 255, 33)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Skelesprout", 3, 2, ItemHelper.getItemString(Items.field_151144_bL), new ItemStack(Items.field_151144_bL, 1), new Color(159, 164, 155)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Brainy", 3, 2, ItemHelper.getItemString(Items.field_151144_bL, 2), new ItemStack(Items.field_151144_bL, 1, 2), new Color(49, 105, 50)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Mindful", 3, 2, ItemHelper.getItemString(Items.field_151144_bL, 3), new ItemStack(Items.field_151144_bL, 1, 3), new Color(232, 186, 131)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Creepots", 3, 2, ItemHelper.getItemString(Items.field_151144_bL, 4), new ItemStack(Items.field_151144_bL, 1, 4), new Color(71, 178, 74)));
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Glowstone", 3, 4, "dustGlowstone", "dustGlowstone#8", new Color(233, 255, 84)), "dustGlowstone");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Redstone", 3, 4, "dustRedstone", "dustRedstone#8", new Color(159, 13, 0)), "dustRedstone");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Sulfur", 3, 4, "dustSulfur", "dustSulfur#8", new Color(212, 190, 85)), "dustSulfur");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Lapis", 3, 4, "gemLapis", "gemLapis#8", new Color(63, 71, 206)), "gemLapis");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Quartz", 3, 4, "gemQuartz", "gemQuartz#4", new Color(255, 255, 255)), "gemQuartz");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Certus", 3, 4, "crystalCertusQuartz", "crystalCertusQuartz#4", new Color(168, 204, 208)), "crystalCertusQuartz");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Ruby", 3, 4, "gemRuby", "gemRuby#8", new Color(212, 48, 55)), "gemRuby");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Peridot", 3, 4, "gemPeridot", "gemPeridot#8", new Color(130, 212, 108)), "gemPeridot");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Topaz", 3, 4, "gemTopaz", "gemTopaz#8", new Color(212, 143, 101)), "gemTopaz");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Tanzanite", 3, 4, "gemTanzanite", "gemTanzanite#8", new Color(42, 7, 96)), "gemTanzanite");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Malachite", 3, 4, "gemMalachite", "gemMalachite#8", new Color(59, 255, 226)), "gemMalachite");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Sapphire", 3, 4, "gemSapphire", "gemSapphire#8", new Color(88, 106, 212)), "gemSapphire");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Amber", 3, 4, "gemAmber", "gemAmber#8", new Color(212, 121, 60)), "gemAmber");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Apatite", 3, 4, "gemApatite", "gemApatite#8", new Color(121, 188, 212)), "gemApatite");
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Witherwheat", 4, 2, ItemHelper.getItemString(Items.field_151144_bL, 1), new ItemStack(Items.field_151144_bL, 1, 1), new Color(52, 52, 51)));
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Diamond", 4, 2, "gemDiamond", "gemDiamond#1", new Color(58, 242, 239)), "gemDiamond");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Emerald", 4, 2, "gemEmerald", "gemEmerald#1", new Color(87, 242, 111)), "gemEmerald");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Platinum", 4, 2, "ingotPlatinum", "ingotPlatinum#1", new Color(30, 208, 243)), "ingotPlatinum");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Yellorium", 4, 2, "ingotYellorium", "ingotYellorium#1", new Color(142, 160, 19)), "ingotYellorium");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Titanium", 4, 2, "ingotTitanium", "ingotTitanium#1", new Color(212, 165, 182)), "ingotTitanium");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Desh", 4, 2, "ingotDesh", "ingotDesh#1", new Color(39, 39, 40)), "ingotDesh");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Cobalt", 4, 2, "ingotCobalt", "ingotCobalt#1", new Color(0, 60, 255)), "ingotCobalt");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Ardite", 4, 2, "ingotArdite", "ingotArdite#1", new Color(255, 102, 0)), "ingotArdite");
        for (CompatibilitySeed compatSeed : CompatibilitySeed.values()) {
            StartupUtils.addDefaultSeedMod(compatSeed);
        }
        SeedCreator.createJsonFromSeeds(SeedRegistry.seedBuilder, defaultSeeds, "DefaultSeeds");
    }

    private static Seed makeSeed(String name, int tier, int amount, String input, String output, Color color, Compat compat) {
        SeedBuilder builder = new SeedBuilder();
        builder.setName(name);
        builder.setTier(tier);
        builder.setAmount(amount);
        builder.setInput(input);
        builder.setOutput(output);
        builder.setColor(color);
        if (compat != null) {
            builder.setCompat(compat);
        }
        return builder.build();
    }

    private static Seed makeSeed(String name, int tier, int amount, String input, ItemStack output, Color color) {
        return StartupUtils.makeSeed(name, tier, amount, input, ItemHelper.getItemString(output), color, null);
    }

    private static Seed makeSeed(String name, int tier, int amount, String input, String output, Color color) {
        return StartupUtils.makeSeed(name, tier, amount, input, output, color, null);
    }

    private static void addDefaultSeedMod(CompatibilitySeed compatibilitySeed) {
        LogHelper.info("Adding compatibility Seed for { " + compatibilitySeed.getModid() + " }");
        if (Loader.isModLoaded((String)compatibilitySeed.getModid()) && compatibilitySeed.getConfig()) {
            defaultSeeds.add(compatibilitySeed.getCompatSeed());
        }
    }

    private static void addDefaultSeedOre(Seed seed, String ore) {
        if (OreDictionary.doesOreNameExist((String)ore)) {
            defaultSeeds.add(seed);
        }
    }

    private static void addDefaultSeed(Seed seed) {
        String[] split = seed.getInput().split(":");
        if (GameData.getItemRegistry().func_148741_d(split[0] + ":" + split[1])) {
            defaultSeeds.add(seed);
        }
    }

    private static Compat getCompat(int sieveChance) {
        return new CompatBuilder().setCompatExNihilio(new CompatBuilder.CompatExNihilioBuilder().setSourceBlock(new BlockStack(Blocks.field_150346_d)).setSieveChance(sieveChance).build()).build();
    }
}

