/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.util.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.filefilter.FileFilterUtils;
import tehnut.resourceful.crops.ResourcefulCrops;
import tehnut.resourceful.crops.api.base.Chance;
import tehnut.resourceful.crops.api.base.Compat;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.base.SeedReq;
import tehnut.resourceful.crops.api.util.BlockStack;
import tehnut.resourceful.crops.util.serialization.serializers.CustomBlockStackJson;
import tehnut.resourceful.crops.util.serialization.serializers.CustomChanceJson;
import tehnut.resourceful.crops.util.serialization.serializers.CustomCompatJson;
import tehnut.resourceful.crops.util.serialization.serializers.CustomListJson;
import tehnut.resourceful.crops.util.serialization.serializers.CustomSeedJson;
import tehnut.resourceful.crops.util.serialization.serializers.CustomSeedReqJson;

public class SeedCreator {
    public static void registerJsonSeeds(GsonBuilder gsonBuilder, File folder) {
        File[] files;
        for (File file : files = folder.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"))) {
            SeedCreator.createSeedsFromJson(gsonBuilder, file);
        }
    }

    public static void registerJsonSeeds(GsonBuilder gsonBuilder) {
        File[] files;
        File folder = new File(ResourcefulCrops.getConfigDir().getPath() + "/seeds");
        for (File file : files = folder.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"))) {
            SeedCreator.createSeedsFromJson(gsonBuilder, file);
        }
    }

    public static List<Seed> createSeedsFromJson(GsonBuilder gsonBuilder, File file) {
        try {
            Gson gson = gsonBuilder.setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
            return (List)gson.fromJson((Reader)new FileReader(file), ArrayList.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createJsonFromSeeds(GsonBuilder gsonBuilder, List list, String fileName) {
        try {
            Gson gson = gsonBuilder.setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
            String reverse = gson.toJson((Object)list, List.class);
            FileWriter fw = new FileWriter(new File(ResourcefulCrops.getConfigDir().getPath() + "/seeds", fileName + ".json"));
            fw.write("{\n\"seeds\": " + reverse + "\n}");
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createJsonFromSeeds(GsonBuilder gsonBuilder, List list) {
        SeedCreator.createJsonFromSeeds(gsonBuilder, list, "PrintedSeeds");
    }

    public static void registerCustomSerializers(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapter(ArrayList.class, (Object)new CustomListJson());
        gsonBuilder.registerTypeAdapter(Seed.class, (Object)new CustomSeedJson());
        gsonBuilder.registerTypeAdapter(BlockStack.class, (Object)new CustomBlockStackJson());
        gsonBuilder.registerTypeAdapter(SeedReq.class, (Object)new CustomSeedReqJson());
        gsonBuilder.registerTypeAdapter(Chance.class, (Object)new CustomChanceJson());
        gsonBuilder.registerTypeAdapter(Compat.class, (Object)new CustomCompatJson());
        gsonBuilder.registerTypeAdapter(Compat.CompatExNihilio.class, (Object)new CustomCompatJson.CustomCompatExNihilioJson());
    }
}

