/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import mantle.lib.client.MantleClientRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.armor.ArmorProxyCommon;
import tconstruct.armor.ArmorTickHandler;
import tconstruct.armor.TinkerArmor;
import tconstruct.armor.gui.ArmorExtendedGui;
import tconstruct.armor.gui.KnapsackGui;
import tconstruct.armor.items.TravelGear;
import tconstruct.armor.model.BeltModel;
import tconstruct.armor.model.BootBump;
import tconstruct.armor.model.HiddenPlayerModel;
import tconstruct.armor.model.WingModel;
import tconstruct.armor.player.ArmorExtended;
import tconstruct.armor.player.KnapsackInventory;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.client.ArmorControls;
import tconstruct.client.tabs.InventoryTabArmorExtended;
import tconstruct.client.tabs.InventoryTabKnapsack;
import tconstruct.client.tabs.InventoryTabVanilla;
import tconstruct.client.tabs.TabRegistry;
import tconstruct.common.TProxyCommon;
import tconstruct.library.accessory.IAccessoryModel;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.tools.TinkerTools;
import tconstruct.world.TinkerWorld;

public class ArmorProxyClient
extends ArmorProxyCommon {
    public static WingModel wings = new WingModel();
    public static BootBump bootbump = new BootBump();
    public static HiddenPlayerModel glove = new HiddenPlayerModel(0.25f, 4);
    public static HiddenPlayerModel vest = new HiddenPlayerModel(0.25f, 1);
    public static BeltModel belt = new BeltModel();
    public static TPlayerStats playerStats = new TPlayerStats();
    public static KnapsackInventory knapsack = new KnapsackInventory();
    public static ArmorExtended armorExtended = new ArmorExtended();
    public static ArmorControls controlInstance;
    Minecraft mc = Minecraft.getMinecraft();
    private static final ResourceLocation hearts;
    private static final ResourceLocation icons;
    Random rand = new Random();
    int updateCounter = 0;
    GameSettings gs;
    double zLevel;

    public ArmorProxyClient() {
        this.gs = Minecraft.getMinecraft().gameSettings;
        this.zLevel = 0.0;
    }

    @Override
    public void preInit() {
        controlInstance = new ArmorControls();
        FMLCommonHandler.instance().bus().register((Object)controlInstance);
        MinecraftForge.EVENT_BUS.register((Object)controlInstance);
        MinecraftForge.EVENT_BUS.register((Object)new TabRegistry());
    }

    @Override
    public void initialize() {
        this.registerGuiHandler();
        this.registerKeys();
        this.registerManualIcons();
        this.registerManualRecipes();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void registerManualIcons() {
        MantleClientRegistry.registerManualIcon((String)"travelgoggles", (ItemStack)TinkerArmor.travelGoggles.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelvest", (ItemStack)TinkerArmor.travelVest.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelwings", (ItemStack)TinkerArmor.travelWings.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelboots", (ItemStack)TinkerArmor.travelBoots.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelbelt", (ItemStack)TinkerArmor.travelBelt.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelglove", (ItemStack)TinkerArmor.travelGlove.getDefaultItem());
    }

    private void registerManualRecipes() {
        ItemStack feather = new ItemStack(Items.feather);
        ItemStack redstone = new ItemStack(Items.redstone);
        ItemStack goggles = TinkerArmor.travelGoggles.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("nightvision", goggles.copy(), new ItemStack(Items.flint_and_steel), new ItemStack((Item)Items.potionitem, 1, 8198), new ItemStack(Items.golden_carrot), null);
        ItemStack vest = TinkerArmor.travelVest.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("dodge", vest.copy(), new ItemStack(Items.ender_eye), new ItemStack(Items.ender_pearl), new ItemStack(Items.sugar), null);
        TConstructClientRegistry.registerManualModifier("stealth", vest.copy(), new ItemStack(Items.fermented_spider_eye), new ItemStack(Items.ender_eye), new ItemStack((Item)Items.potionitem, 1, 8206), new ItemStack(Items.golden_carrot));
        ItemStack wings = TinkerArmor.travelWings.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("doublejumpwings", wings.copy(), new ItemStack(Items.ghast_tear), new ItemStack(TinkerWorld.slimeGel, 1, 0), new ItemStack((Block)Blocks.piston), null);
        ItemStack[] recipe = new ItemStack[]{new ItemStack(TinkerWorld.slimeGel, 1, 0), new ItemStack(Items.ender_pearl), feather, feather, feather, feather, feather, feather};
        ItemStack modWings = ModifyBuilder.instance.modifyItem(wings, recipe);
        MantleClientRegistry.registerManualLargeRecipe((String)"featherfall", (ItemStack)modWings.copy(), (ItemStack[])new ItemStack[]{feather, new ItemStack(TinkerWorld.slimeGel, 1, 0), feather, feather, wings.copy(), feather, feather, new ItemStack(Items.ender_pearl), feather});
        ItemStack boots = TinkerArmor.travelBoots.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("doublejumpboots", boots.copy(), new ItemStack(Items.ghast_tear), new ItemStack(TinkerWorld.slimeGel, 1, 1), new ItemStack((Block)Blocks.piston), null);
        TConstructClientRegistry.registerManualModifier("waterwalk", boots.copy(), new ItemStack(Blocks.waterlily), new ItemStack(Blocks.waterlily));
        TConstructClientRegistry.registerManualModifier("leadboots", boots.copy(), new ItemStack(Blocks.iron_block));
        TConstructClientRegistry.registerManualModifier("slimysoles", boots.copy(), new ItemStack(TinkerWorld.slimePad, 1, 0), new ItemStack(TinkerWorld.slimePad, 1, 0));
        ItemStack gloves = TinkerArmor.travelGlove.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("glovehaste", gloves.copy(), redstone, new ItemStack(Blocks.redstone_block));
        TConstructClientRegistry.registerManualModifier("gloveknuckles", gloves.copy(), new ItemStack(Items.quartz), new ItemStack(Blocks.quartz_block, 1, Short.MAX_VALUE));
        ItemStack moss = new ItemStack(TinkerTools.materials, 1, 6);
        TConstructClientRegistry.registerManualModifier("mossgoggles", goggles.copy(), moss.copy());
        TConstructClientRegistry.registerManualModifier("mossvest", vest.copy(), moss.copy());
        TConstructClientRegistry.registerManualModifier("mosswings", wings.copy(), moss.copy());
        TConstructClientRegistry.registerManualModifier("mossboots", boots.copy(), moss.copy());
    }

    @Override
    protected void registerGuiHandler() {
        super.registerGuiHandler();
        TProxyCommon.registerClientGuiHandler(100, this);
        TProxyCommon.registerClientGuiHandler(101, this);
        TProxyCommon.registerClientGuiHandler(102, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 100) {
            GuiInventory inventory = new GuiInventory(player);
            return inventory;
        }
        if (ID == 101) {
            armorExtended.init((EntityPlayer)Minecraft.getMinecraft().thePlayer);
            return new ArmorExtendedGui(player.inventory, armorExtended);
        }
        if (ID == 102) {
            knapsack.init((EntityPlayer)Minecraft.getMinecraft().thePlayer);
            return new KnapsackGui(player.inventory, knapsack);
        }
        return null;
    }

    @Override
    public void registerTickHandler() {
        FMLCommonHandler.instance().bus().register((Object)new ArmorTickHandler());
    }

    @Override
    public void registerKeys() {
        controlInstance.registerKeys();
        TabRegistry.registerTab(new InventoryTabVanilla());
        TabRegistry.registerTab(new InventoryTabArmorExtended());
        TabRegistry.registerTab(new InventoryTabKnapsack());
    }

    @SubscribeEvent
    public void goggleZoom(FOVUpdateEvent event) {
        ItemStack helmet;
        if (ArmorControls.zoom && (helmet = event.entity.getCurrentArmor(3)) != null && helmet.getItem() instanceof TravelGear) {
            event.newfov = 0.3f;
        }
    }

    @SubscribeEvent
    public void renderHealthbar(RenderGameOverlayEvent.Pre event) {
        if (Loader.isModLoaded((String)"rpghud")) {
            return;
        }
        if ((!Loader.isModLoaded((String)"tukmc_Vz") || Loader.isModLoaded((String)"borderlands")) && event.type == RenderGameOverlayEvent.ElementType.HEALTH) {
            boolean highlight;
            ++this.updateCounter;
            ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.displayWidth, this.mc.displayHeight);
            int scaledWidth = scaledresolution.getScaledWidth();
            int scaledHeight = scaledresolution.getScaledHeight();
            int xBasePos = scaledWidth / 2 - 91;
            int yBasePos = scaledHeight - 39;
            boolean bl = highlight = this.mc.thePlayer.hurtResistantTime / 3 % 2 == 1;
            if (this.mc.thePlayer.hurtResistantTime < 10) {
                highlight = false;
            }
            IAttributeInstance attrMaxHealth = this.mc.thePlayer.getEntityAttribute(SharedMonsterAttributes.maxHealth);
            int health = MathHelper.ceiling_float_int((float)this.mc.thePlayer.getHealth());
            int healthLast = MathHelper.ceiling_float_int((float)this.mc.thePlayer.prevHealth);
            float healthMax = (float)attrMaxHealth.getAttributeValue();
            if (healthMax > 20.0f) {
                healthMax = 20.0f;
            }
            float absorb = this.mc.thePlayer.getAbsorptionAmount();
            int healthRows = MathHelper.ceiling_float_int((float)((healthMax + absorb) / 2.0f / 10.0f));
            int rowHeight = Math.max(10 - (healthRows - 2), 3);
            this.rand.setSeed(this.updateCounter * 312871);
            int left = scaledWidth / 2 - 91;
            int top = scaledHeight - GuiIngameForge.left_height;
            if (!GuiIngameForge.renderExperiance) {
                top += 7;
                yBasePos += 7;
            }
            int regen = -1;
            if (this.mc.thePlayer.isPotionActive(Potion.regeneration)) {
                regen = this.updateCounter % 25;
            }
            int TOP = 9 * (this.mc.theWorld.getWorldInfo().isHardcoreModeEnabled() ? 5 : 0);
            int BACKGROUND = highlight ? 25 : 16;
            int MARGIN = 16;
            if (this.mc.thePlayer.isPotionActive(Potion.poison)) {
                MARGIN += 36;
            } else if (this.mc.thePlayer.isPotionActive(Potion.wither)) {
                MARGIN += 72;
            }
            float absorbRemaining = absorb;
            for (int i = MathHelper.ceiling_float_int((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
                boolean b0 = highlight;
                int row = MathHelper.ceiling_float_int((float)((float)(i + 1) / 10.0f)) - 1;
                int x = left + i % 10 * 8;
                int y = top - row * rowHeight;
                if (health <= 4) {
                    y += this.rand.nextInt(2);
                }
                if (i == regen) {
                    y -= 2;
                }
                this.drawTexturedModalRect(x, y, BACKGROUND, TOP, 9, 9);
                if (highlight) {
                    if (i * 2 + 1 < healthLast) {
                        this.drawTexturedModalRect(x, y, MARGIN + 54, TOP, 9, 9);
                    } else if (i * 2 + 1 == healthLast) {
                        this.drawTexturedModalRect(x, y, MARGIN + 63, TOP, 9, 9);
                    }
                }
                if (absorbRemaining > 0.0f) {
                    if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                        this.drawTexturedModalRect(x, y, MARGIN + 153, TOP, 9, 9);
                    } else {
                        this.drawTexturedModalRect(x, y, MARGIN + 144, TOP, 9, 9);
                    }
                    absorbRemaining -= 2.0f;
                    continue;
                }
                if (i * 2 + 1 < health) {
                    this.drawTexturedModalRect(x, y, MARGIN + 36, TOP, 9, 9);
                    continue;
                }
                if (i * 2 + 1 != health) continue;
                this.drawTexturedModalRect(x, y, MARGIN + 45, TOP, 9, 9);
            }
            int potionOffset = 0;
            PotionEffect potion = this.mc.thePlayer.getActivePotionEffect(Potion.wither);
            if (potion != null) {
                potionOffset = 18;
            }
            if ((potion = this.mc.thePlayer.getActivePotionEffect(Potion.poison)) != null) {
                potionOffset = 9;
            }
            if (this.mc.theWorld.getWorldInfo().isHardcoreModeEnabled()) {
                potionOffset += 27;
            }
            this.mc.getTextureManager().bindTexture(hearts);
            int hp = MathHelper.ceiling_float_int((float)this.mc.thePlayer.getHealth());
            for (int iter = 0; iter < hp / 20; ++iter) {
                int renderHearts = (hp - 20 * (iter + 1)) / 2;
                if (renderHearts > 10) {
                    renderHearts = 10;
                }
                for (int i = 0; i < renderHearts; ++i) {
                    int y = 0;
                    if (i == regen) {
                        y -= 2;
                    }
                    this.drawTexturedModalRect(xBasePos + 8 * i, yBasePos + y, 0 + 18 * iter, potionOffset, 9, 9);
                }
                if (hp % 2 != 1 || renderHearts >= 10) continue;
                this.drawTexturedModalRect(xBasePos + 8 * renderHearts, yBasePos, 9 + 18 * iter, potionOffset, 9, 9);
            }
            this.mc.getTextureManager().bindTexture(icons);
            GuiIngameForge.left_height += 10;
            if (absorb > 0.0f) {
                GuiIngameForge.left_height += 10;
            }
            event.setCanceled(true);
            if (event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && this.gs.thirdPersonView != 0) {
                event.setCanceled(true);
            }
        }
    }

    public void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)(par1 + 0), (double)(par2 + par6), this.zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + par6) * f1));
        tessellator.addVertexWithUV((double)(par1 + par5), (double)(par2 + par6), this.zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1));
        tessellator.addVertexWithUV((double)(par1 + par5), (double)(par2 + 0), this.zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + 0) * f1));
        tessellator.addVertexWithUV((double)(par1 + 0), (double)(par2 + 0), this.zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + 0) * f1));
        tessellator.draw();
    }

    @SubscribeEvent
    public void adjustArmor(RenderPlayerEvent.SetArmorModel event) {
        switch (event.slot) {
            case 1: {
                ArmorProxyClient.vest.onGround = event.renderer.modelBipedMain.onGround;
                ArmorProxyClient.vest.isRiding = event.renderer.modelBipedMain.isRiding;
                ArmorProxyClient.vest.isChild = event.renderer.modelBipedMain.isChild;
                ArmorProxyClient.vest.isSneak = event.renderer.modelBipedMain.isSneak;
            }
            case 2: {
                ArmorProxyClient.wings.onGround = event.renderer.modelBipedMain.onGround;
                ArmorProxyClient.wings.isRiding = event.renderer.modelBipedMain.isRiding;
                ArmorProxyClient.wings.isChild = event.renderer.modelBipedMain.isChild;
                ArmorProxyClient.wings.isSneak = event.renderer.modelBipedMain.isSneak;
                ArmorProxyClient.glove.onGround = event.renderer.modelBipedMain.onGround;
                ArmorProxyClient.glove.isRiding = event.renderer.modelBipedMain.isRiding;
                ArmorProxyClient.glove.isChild = event.renderer.modelBipedMain.isChild;
                ArmorProxyClient.glove.isSneak = event.renderer.modelBipedMain.isSneak;
                ArmorProxyClient.glove.heldItemLeft = event.renderer.modelBipedMain.heldItemLeft;
                ArmorProxyClient.glove.heldItemRight = event.renderer.modelBipedMain.heldItemRight;
                ArmorProxyClient.belt.onGround = event.renderer.modelBipedMain.onGround;
                ArmorProxyClient.belt.isRiding = event.renderer.modelBipedMain.isRiding;
                ArmorProxyClient.belt.isChild = event.renderer.modelBipedMain.isChild;
                ArmorProxyClient.belt.isSneak = event.renderer.modelBipedMain.isSneak;
                this.renderArmorExtras(event);
                break;
            }
            case 3: {
                ArmorProxyClient.bootbump.onGround = event.renderer.modelBipedMain.onGround;
                ArmorProxyClient.bootbump.isRiding = event.renderer.modelBipedMain.isRiding;
                ArmorProxyClient.bootbump.isChild = event.renderer.modelBipedMain.isChild;
                ArmorProxyClient.bootbump.isSneak = event.renderer.modelBipedMain.isSneak;
            }
        }
    }

    void renderArmorExtras(RenderPlayerEvent.SetArmorModel event) {
        ModelBiped model;
        Item item;
        float pitch;
        float partialTick = event.partialRenderTick;
        EntityPlayer player = event.entityPlayer;
        if (player != Minecraft.getMinecraft().thePlayer) {
            return;
        }
        float posX = (float)(player.lastTickPosX + (player.posX - player.lastTickPosX) * (double)partialTick);
        float posY = (float)(player.lastTickPosY + (player.posY - player.lastTickPosY) * (double)partialTick);
        float posZ = (float)(player.lastTickPosZ + (player.posZ - player.lastTickPosZ) * (double)partialTick);
        float yawOffset = this.interpolateRotation(player.prevRenderYawOffset, player.renderYawOffset, partialTick);
        float yawRotation = this.interpolateRotation(player.prevRotationYawHead, player.rotationYawHead, partialTick);
        float zeropointsixtwofive = 0.0625f;
        if (player.isRiding() && player.ridingEntity instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase1 = (EntityLivingBase)player.ridingEntity;
            yawOffset = this.interpolateRotation(entitylivingbase1.prevRenderYawOffset, entitylivingbase1.renderYawOffset, partialTick);
            pitch = MathHelper.wrapAngleTo180_float((float)(yawRotation - yawOffset));
            if (pitch < -85.0f) {
                pitch = -85.0f;
            }
            if (pitch >= 85.0f) {
                pitch = 85.0f;
            }
            yawOffset = yawRotation - pitch;
            if (pitch * pitch > 2500.0f) {
                yawOffset += pitch * 0.2f;
            }
        }
        pitch = this.handleRotationFloat((EntityLivingBase)player, partialTick);
        float bodyRotation = player.prevRotationPitch + (player.rotationPitch - player.prevRotationPitch) * partialTick;
        float limbSwing = player.prevLimbSwingAmount + (player.limbSwingAmount - player.prevLimbSwingAmount) * partialTick;
        float limbSwingMod = player.limbSwing - player.limbSwingAmount * (1.0f - partialTick);
        ArmorExtended armor = armorExtended;
        if (armor != null && armor.inventory[1] != null) {
            item = armor.inventory[1].getItem();
            model = item.getArmorModel((EntityLivingBase)player, armor.inventory[1], 4);
            if (item instanceof IAccessoryModel) {
                this.mc.getTextureManager().bindTexture(((IAccessoryModel)item).getWearbleTexture((Entity)player, armor.inventory[1], 1));
                model.setLivingAnimations((EntityLivingBase)player, limbSwingMod, limbSwing, partialTick);
                model.render((Entity)player, limbSwingMod, limbSwing, pitch, yawRotation - yawOffset, bodyRotation, 0.0625f);
            }
        }
        if (armor != null && armor.inventory[3] != null) {
            item = armor.inventory[3].getItem();
            model = item.getArmorModel((EntityLivingBase)player, armor.inventory[3], 5);
            if (item instanceof IAccessoryModel) {
                this.mc.getTextureManager().bindTexture(((IAccessoryModel)item).getWearbleTexture((Entity)player, armor.inventory[1], 1));
                model.setLivingAnimations((EntityLivingBase)player, limbSwingMod, limbSwing, partialTick);
                model.render((Entity)player, limbSwingMod, limbSwing, pitch, yawRotation - yawOffset, bodyRotation, 0.0625f);
            }
        }
    }

    private float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }

    protected float handleRotationFloat(EntityLivingBase par1EntityLivingBase, float par2) {
        return (float)par1EntityLivingBase.ticksExisted + par2;
    }

    @Override
    public void updatePlayerStats(TPlayerStats stats) {
        playerStats.copyFrom(stats, false);
        armorExtended = stats.armor;
        knapsack = stats.knapsack;
    }

    static {
        hearts = new ResourceLocation("tinker", "textures/gui/newhearts.png");
        icons = new ResourceLocation("textures/gui/icons.png");
    }
}

