/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor.player;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.library.accessory.IHealthAccessory;

public class ArmorExtended
implements IInventory {
    public ItemStack[] inventory = new ItemStack[7];
    public WeakReference<EntityPlayer> parent;
    public UUID globalID = UUID.fromString("B243BE32-DC1B-4C53-8D13-8752D5C69D5B");
    private static int soulBoundID = -6;

    public void init(EntityPlayer player) {
        this.parent = new WeakReference<EntityPlayer>(player);
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public boolean isStackInSlot(int slot) {
        return this.inventory[slot] != null;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory[slot];
    }

    public ItemStack decrStackSize(int slot, int quantity) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].stackSize <= quantity) {
                ItemStack stack = this.inventory[slot];
                this.inventory[slot] = null;
                return stack;
            }
            ItemStack split = this.inventory[slot].splitStack(quantity);
            if (this.inventory[slot].stackSize == 0) {
                this.inventory[slot] = null;
            }
            EntityPlayer player = (EntityPlayer)this.parent.get();
            TPlayerStats stats = TPlayerStats.get(player);
            this.recalculateHealth(player, stats);
            return split;
        }
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
        EntityPlayer player = (EntityPlayer)this.parent.get();
        TPlayerStats stats = TPlayerStats.get(player);
        this.recalculateHealth(player, stats);
    }

    public String getInventoryName() {
        return "";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        EntityPlayer player = (EntityPlayer)this.parent.get();
        TPlayerStats stats = TPlayerStats.get(player);
        this.recalculateHealth(player, stats);
    }

    public void recalculateHealth(EntityPlayer player, TPlayerStats stats) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (this.inventory[4] != null || this.inventory[5] != null || this.inventory[6] != null) {
            int bonusHP = 0;
            for (int i = 4; i < 7; ++i) {
                ItemStack stack = this.inventory[i];
                if (stack == null || !(stack.getItem() instanceof IHealthAccessory)) continue;
                bonusHP += ((IHealthAccessory)stack.getItem()).getHealthBoost(stack);
            }
            int prevHealth = stats.bonusHealth;
            stats.bonusHealth = bonusHP;
            int healthChange = bonusHP - prevHealth;
            if (healthChange != 0) {
                IAttributeInstance attributeinstance = player.getAttributeMap().getAttributeInstance(SharedMonsterAttributes.maxHealth);
                try {
                    attributeinstance.removeModifier(attributeinstance.getModifier(this.globalID));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                attributeinstance.applyModifier(new AttributeModifier(this.globalID, "tconstruct.heartCanister", (double)bonusHP, 0));
            }
        } else if (this.parent != null && this.parent.get() != null) {
            int bonusHP;
            int prevHealth = stats.bonusHealth;
            stats.bonusHealth = bonusHP = 0;
            int healthChange = bonusHP - prevHealth;
            if (healthChange != 0) {
                IAttributeInstance attributeinstance = player.getAttributeMap().getAttributeInstance(SharedMonsterAttributes.maxHealth);
                try {
                    attributeinstance.removeModifier(attributeinstance.getModifier(this.globalID));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public void openChest() {
    }

    public void closeChest() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        return false;
    }

    public void saveToNBT(NBTTagCompound tagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound invSlot = new NBTTagCompound();
            invSlot.setByte("Slot", (byte)i);
            this.inventory[i].writeToNBT(invSlot);
            tagList.appendTag((NBTBase)invSlot);
        }
        tagCompound.setTag("Inventory", (NBTBase)tagList);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound != null) {
            NBTTagList tagList = tagCompound.getTagList("Inventory", 10);
            for (int i = 0; i < tagList.tagCount(); ++i) {
                NBTTagCompound nbttagcompound = tagList.getCompoundTagAt(i);
                int j = nbttagcompound.getByte("Slot") & 0xFF;
                ItemStack itemstack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound);
                if (itemstack == null) continue;
                this.inventory[j] = itemstack;
            }
        }
    }

    public static int getSoulBoundID() {
        if (soulBoundID == -6) {
            ArmorExtended.setSoulBoundID();
        }
        return soulBoundID;
    }

    private static void setSoulBoundID() {
        for (Enchantment ench : Enchantment.enchantmentsList) {
            if (ench == null || !ench.getName().equals("enchantment.enderio.soulBound")) continue;
            soulBoundID = ench.effectId;
            return;
        }
        soulBoundID = -1;
    }

    public static boolean isSoulBounded(ItemStack stack) {
        int soulBound = ArmorExtended.getSoulBoundID();
        NBTTagList stackEnch = stack.getEnchantmentTagList();
        if (soulBound >= 0 && stackEnch != null) {
            for (int i = 0; i < stackEnch.tagCount(); ++i) {
                int id = stackEnch.getCompoundTagAt(i).getInteger("id");
                if (id != soulBound) continue;
                return true;
            }
        }
        return false;
    }

    public void dropItems() {
        EntityPlayer player = (EntityPlayer)this.parent.get();
        for (int i = 0; i < 4; ++i) {
            if (this.inventory[i] == null || ArmorExtended.isSoulBounded(this.inventory[i])) continue;
            player.func_146097_a(this.inventory[i], true, false);
            this.inventory[i] = null;
        }
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public void writeInventoryToStream(ByteBuf os) throws IOException {
        for (int i = 0; i < this.inventory.length; ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)os, (ItemStack)this.inventory[i]);
        }
    }

    public void readInventoryFromStream(ByteBuf is) throws IOException {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = ByteBufUtils.readItemStack((ByteBuf)is);
        }
    }
}

