/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.traps;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mantle.blocks.MantleBlock;
import mantle.world.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;

public class Landmine
extends MantleBlock {
    private EnumCreatureType triggerMobType = EnumCreatureType.monster;

    public Landmine(EnumCreatureType par3EnumCreatureType, Material par4Material) {
        super(par4Material);
        this.setCreativeTab(TConstructRegistry.blockTab);
        this.setTickRandomly(true);
        float var5 = 0.0625f;
        this.setBlockBounds(var5, 0.0f, var5, 1.0f - var5, 0.03125f, 1.0f - var5);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        Block block = world.getBlock(x, y - 1, z);
        if (block != null) {
            return block.getIcon(world, x, y - 1, z, side);
        }
        return Blocks.sponge.getIcon(side, world.getBlockMetadata(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return Blocks.sponge.getIcon(1, meta);
    }

    public void registerBlockIcons(IIconRegister par1IconRegister) {
    }

    public int tickRate() {
        return 20;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return true;
    }

    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        return World.doesBlockHaveSolidTopSurface((IBlockAccess)par1World, (int)par2, (int)(par3 - 1), (int)par4) || BlockFence.func_149825_a((Block)par1World.getBlock(par2, par3 - 1, par4));
    }

    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, Block par5) {
        boolean var6 = false;
        if (!World.doesBlockHaveSolidTopSurface((IBlockAccess)par1World, (int)par2, (int)(par3 - 1), (int)par4) && !BlockFence.func_149825_a((Block)par1World.getBlock(par2, par3 - 1, par4))) {
            var6 = true;
        }
        if (var6) {
            this.dropBlockAsItem(par1World, par2, par3, par4, par1World.getBlockMetadata(par2, par3, par4), 0);
        }
    }

    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (!par1World.isRemote && par1World.getBlockMetadata(par2, par3, par4) != 0) {
            this.setStateIfMobInteractsWithPlate(par1World, par2, par3, par4);
        }
    }

    public void onEntityCollidedWithBlock(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        if (!par1World.isRemote && par1World.getBlockMetadata(par2, par3, par4) != 1) {
            this.setStateIfMobInteractsWithPlate(par1World, par2, par3, par4);
        }
    }

    private void setStateIfMobInteractsWithPlate(World world, int posX, int posY, int posZ) {
        boolean var5 = world.getBlockMetadata(posX, posY, posZ) == 1;
        boolean var6 = false;
        float var7 = 0.125f;
        List var8 = null;
        if (this.triggerMobType == EnumCreatureType.creature) {
            var8 = world.getEntitiesWithinAABBExcludingEntity((Entity)null, AxisAlignedBB.getBoundingBox((double)((float)posX + var7), (double)posY, (double)((float)posZ + var7), (double)((float)(posX + 1) - var7), (double)((double)posY + 0.25), (double)((float)(posZ + 1) - var7)));
        }
        if (this.triggerMobType == EnumCreatureType.monster) {
            var8 = world.getEntitiesWithinAABB(EntityLiving.class, AxisAlignedBB.getBoundingBox((double)((float)posX + var7), (double)posY, (double)((float)posZ + var7), (double)((float)(posX + 1) - var7), (double)((double)posY + 0.25), (double)((float)(posZ + 1) - var7)));
        }
        if (!var8.isEmpty()) {
            for (Entity var10 : var8) {
                if (var10.doesEntityNotTriggerPressurePlate()) continue;
                var6 = true;
                break;
            }
        }
        if (var6 && !var5) {
            WorldHelper.setBlockToAir((World)world, (int)posX, (int)posY, (int)posZ);
            world.createExplosion((Entity)null, (double)posX, (double)posY, (double)posZ, 2.0f, true);
        }
    }

    public void breakBlock(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        if (par6 > 0) {
            par1World.notifyBlocksOfNeighborChange(par2, par3, par4, (Block)this);
            par1World.notifyBlocksOfNeighborChange(par2, par3 - 1, par4, (Block)this);
        }
        super.breakBlock(par1World, par2, par3, par4, par5, par6);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        boolean var5 = par1IBlockAccess.getBlockMetadata(par2, par3, par4) == 1;
        float var6 = 0.0625f;
        if (var5) {
            this.setBlockBounds(var6, 0.0f, var6, 1.0f - var6, 0.03125f, 1.0f - var6);
        } else {
            this.setBlockBounds(var6, 0.0f, var6, 1.0f - var6, 0.0625f, 1.0f - var6);
        }
    }

    public void setBlockBoundsForItemRender() {
        float var1 = 0.5f;
        float var2 = 0.125f;
        float var3 = 0.5f;
        this.setBlockBounds(0.5f - var1, 0.5f - var2, 0.5f - var3, 0.5f + var1, 0.5f + var2, 0.5f + var3);
    }

    public int getMobilityFlag() {
        return 1;
    }
}

