/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.AOEHarvestTool;
import tconstruct.tools.TinkerTools;

public class Hammer
extends AOEHarvestTool {
    static Material[] materials = new Material[]{Material.rock, Material.iron, Material.ice, Material.glass, Material.piston, Material.anvil};

    public Hammer() {
        super(2, 1, 0);
        this.setUnlocalizedName("InfiTool.Hammer");
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    public int durabilityTypeAccessory() {
        return 2;
    }

    @Override
    public int durabilityTypeExtra() {
        return 2;
    }

    @Override
    protected String getHarvestType() {
        return "pickaxe";
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    @Override
    public Item getHeadItem() {
        return TinkerTools.hammerHead;
    }

    @Override
    public Item getHandleItem() {
        return TinkerTools.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerTools.largePlate;
    }

    @Override
    public Item getExtraItem() {
        return TinkerTools.largePlate;
    }

    @Override
    public float getDurabilityModifier() {
        return 4.5f;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_hammer_head";
            }
            case 1: {
                return "_hammer_handle_broken";
            }
            case 2: {
                return "_hammer_handle";
            }
            case 3: {
                return "_hammer_front";
            }
            case 4: {
                return "_hammer_back";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_hammer_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "hammer";
    }

    @Override
    public IIcon getIcon(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.getTagCompound();
        if (tags != null) {
            tags = stack.getTagCompound().getCompoundTag("InfiTool");
            if (renderPass == 0) {
                if (tags.getBoolean("Broken")) {
                    return this.getCorrectIcon(this.brokenIcons, tags.getInteger("RenderHandle"));
                }
                return this.getCorrectIcon(this.handleIcons, tags.getInteger("RenderHandle"));
            }
            if (renderPass == 1) {
                return this.getCorrectIcon(this.headIcons, tags.getInteger("RenderHead"));
            }
        }
        return super.getIcon(stack, renderPass);
    }

    @Override
    public void getSubItems(Item id, CreativeTabs tab, List list) {
        super.getSubItems(id, tab, list);
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, 10), new ItemStack(this.getHandleItem(), 1, 8), new ItemStack(this.getAccessoryItem(), 1, 11), new ItemStack(this.getExtraItem(), 1, 11), StatCollector.translateToLocal((String)"tool.infiminer"));
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        tags.setBoolean("Special", true);
        tags.setInteger("Modifiers", 0);
        tags.setInteger("Attack", 21474836);
        tags.setInteger("TotalDurability", 21474836);
        tags.setInteger("BaseDurability", 21474836);
        tags.setInteger("MiningSpeed", 21474836);
        tags.setInteger("Unbreaking", 10);
        tags.setBoolean("Built", true);
        list.add(tool);
    }

    @Override
    public float breakSpeedModifier() {
        return 0.4f;
    }

    @Override
    public float stoneboundModifier() {
        return 216.0f;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"weapon", "harvest", "melee", "bludgeoning"};
    }
}

