/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tconstruct.library.tools.Weapon;
import tconstruct.tools.TinkerTools;

public class Longsword
extends Weapon {
    public Longsword() {
        super(4);
        this.setUnlocalizedName("InfiTool.Longsword");
    }

    @Override
    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (player.onGround) {
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        }
        return stack;
    }

    @Override
    public float chargeAttack() {
        return 1.5f;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int useCount) {
        int time = this.getMaxItemUseDuration(stack) - useCount;
        if (time > 5) {
            player.addExhaustion(0.2f);
            player.setSprinting(true);
            float increase = (float)(0.02 * (double)time + 0.2);
            if (increase > 0.56f) {
                increase = 0.56f;
            }
            player.motionY += (double)increase;
            float speed = 0.05f * (float)time;
            if (speed > 0.925f) {
                speed = 0.925f;
            }
            player.motionX = -MathHelper.sin((float)(player.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(player.rotationPitch / 180.0f * (float)Math.PI)) * speed;
            player.motionZ = MathHelper.cos((float)(player.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(player.rotationPitch / 180.0f * (float)Math.PI)) * speed;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.onUpdate(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).getItemInUse()) != null && usingItem.getItem() == this) {
            player.movementInput.moveForward *= 5.0f;
            player.movementInput.moveStrafe *= 5.0f;
        }
    }

    @Override
    public Item getHeadItem() {
        return TinkerTools.swordBlade;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerTools.handGuard;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_longsword_blade";
            }
            case 1: {
                return "_longsword_blade_broken";
            }
            case 2: {
                return "_longsword_handle";
            }
            case 3: {
                return "_longsword_accessory";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_longsword_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "longsword";
    }
}

