/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.HarvestTool;

public abstract class AOEHarvestTool
extends HarvestTool {
    public int breakRadius;
    public int breakDepth;

    public AOEHarvestTool(int baseDamage, int breakRadius, int breakDepth) {
        super(baseDamage);
        this.breakRadius = breakRadius;
        this.breakDepth = breakDepth;
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        Block block = player.worldObj.getBlock(x, y, z);
        int meta = player.worldObj.getBlockMetadata(x, y, z);
        if (block == null || !this.isEffective(block, meta) || !stack.hasTagCompound()) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        NBTTagCompound toolTags = stack.getTagCompound().getCompoundTag("InfiTool");
        if (toolTags == null || toolTags.getBoolean("Broken")) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        MovingObjectPosition mop = AbilityHelper.raytraceFromEntity(player.worldObj, (Entity)player, false, 4.5);
        if (mop == null) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        int sideHit = mop.sideHit;
        int xRange = this.breakRadius;
        int yRange = this.breakRadius;
        int zRange = this.breakDepth;
        switch (sideHit) {
            case 0: 
            case 1: {
                yRange = this.breakDepth;
                zRange = this.breakRadius;
                break;
            }
            case 2: 
            case 3: {
                xRange = this.breakRadius;
                zRange = this.breakDepth;
                break;
            }
            case 4: 
            case 5: {
                xRange = this.breakDepth;
                zRange = this.breakRadius;
            }
        }
        for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
            for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                    if (xPos == x && yPos == y && zPos == z || super.onBlockStartBreak(stack, xPos, yPos, zPos, player)) continue;
                    this.breakExtraBlock(player.worldObj, xPos, yPos, zPos, sideHit, player, x, y, z);
                }
            }
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }
}

