/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.HarvestTool;

public abstract class DualHarvestTool
extends HarvestTool {
    public DualHarvestTool(int baseDamage) {
        super(baseDamage);
    }

    @Override
    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (stack == null || !(stack.getItem() instanceof HarvestTool)) {
            return -1;
        }
        if (toolClass == null) {
            return -1;
        }
        if (!stack.hasTagCompound()) {
            return -1;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        if (tags.getBoolean("Broken")) {
            return -1;
        }
        if (this.getHarvestType().equals(toolClass)) {
            return tags.getInteger("HarvestLevel");
        }
        if (this.getSecondHarvestType().equals(toolClass)) {
            return tags.getInteger("HarvestLevel2");
        }
        return -1;
    }

    @Override
    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        int i;
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        if (tags.getBoolean("Broken")) {
            return 0.1f;
        }
        Material[] materials = this.getEffectiveMaterials();
        for (i = 0; i < materials.length; ++i) {
            if (materials[i] != block.getMaterial()) continue;
            if (block.getHarvestLevel(meta) <= tags.getInteger("HarvestLevel")) {
                return AbilityHelper.calcDualToolSpeed(this, tags, false);
            }
            return 0.1f;
        }
        materials = this.getEffectiveSecondaryMaterials();
        for (i = 0; i < materials.length; ++i) {
            if (materials[i] != block.getMaterial()) continue;
            if (block.getHarvestLevel(meta) <= tags.getInteger("HarvestLevel2")) {
                return AbilityHelper.calcDualToolSpeed(this, tags, true);
            }
            return 0.1f;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    @Override
    public boolean isEffective(Material material) {
        if (super.isEffective(material)) {
            return true;
        }
        for (Material m : this.getEffectiveSecondaryMaterials()) {
            if (m != material) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"harvest", "dualharvest"};
    }

    protected abstract Material[] getEffectiveSecondaryMaterials();

    protected abstract String getSecondHarvestType();
}

