/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;

public abstract class HarvestTool
extends ToolCore {
    public HarvestTool(int baseDamage) {
        super(baseDamage);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (stack == null || !(stack.getItem() instanceof HarvestTool)) {
            return -1;
        }
        if (toolClass == null || !this.getHarvestType().equals(toolClass)) {
            return -1;
        }
        if (!stack.hasTagCompound()) {
            return -1;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        if (tags.getBoolean("Broken")) {
            return 0;
        }
        return tags.getInteger("HarvestLevel");
    }

    @Override
    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (!stack.hasTagCompound()) {
            return 1.0f;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        if (tags.getBoolean("Broken")) {
            return 0.1f;
        }
        if (this.isEffective(block, meta)) {
            return this.calculateStrength(tags, block, meta);
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public float calculateStrength(NBTTagCompound tags, Block block, int meta) {
        int hlvl = block.getHarvestLevel(meta);
        if (hlvl > tags.getInteger("HarvestLevel")) {
            return 0.1f;
        }
        return AbilityHelper.calcToolSpeed(this, tags);
    }

    public float breakSpeedModifier() {
        return 1.0f;
    }

    public float stoneboundModifier() {
        return 72.0f;
    }

    public boolean func_150897_b(Block block) {
        return this.isEffective(block.getMaterial());
    }

    @Override
    public String[] getTraits() {
        return new String[]{"harvest"};
    }

    protected abstract Material[] getEffectiveMaterials();

    protected abstract String getHarvestType();

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet<String> set = new HashSet<String>();
        if (stack != null && stack.getItem() instanceof HarvestTool) {
            set.add(((HarvestTool)stack.getItem()).getHarvestType());
        }
        return set;
    }

    public boolean isEffective(Block block, int meta) {
        if (this.getHarvestType().equals(block.getHarvestTool(meta))) {
            return true;
        }
        return this.isEffective(block.getMaterial());
    }

    public boolean isEffective(Material material) {
        for (Material m : this.getEffectiveMaterials()) {
            if (m != material) continue;
            return true;
        }
        return false;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        Item item;
        boolean used = false;
        int hotbarSlot = player.inventory.currentItem;
        int itemSlot = hotbarSlot == 0 ? 8 : hotbarSlot + 1;
        ItemStack nearbyStack = null;
        if (hotbarSlot < 8 && (nearbyStack = player.inventory.getStackInSlot(itemSlot)) != null && ((item = nearbyStack.getItem()) instanceof ItemBlock || item != null && item == TinkerTools.openBlocksDevNull)) {
            Block blockToPlace;
            int posX = x;
            int posY = y;
            int posZ = z;
            switch (side) {
                case 0: {
                    --posY;
                    break;
                }
                case 1: {
                    ++posY;
                    break;
                }
                case 2: {
                    --posZ;
                    break;
                }
                case 3: {
                    ++posZ;
                    break;
                }
                case 4: {
                    --posX;
                    break;
                }
                case 5: {
                    ++posX;
                }
            }
            AxisAlignedBB blockBounds = AxisAlignedBB.getBoundingBox((double)posX, (double)posY, (double)posZ, (double)(posX + 1), (double)(posY + 1), (double)(posZ + 1));
            AxisAlignedBB playerBounds = player.boundingBox;
            if (item instanceof ItemBlock && (blockToPlace = ((ItemBlock)item).field_150939_a).getMaterial().blocksMovement() && playerBounds.intersectsWith(blockBounds)) {
                return false;
            }
            int dmg = nearbyStack.getItemDamage();
            int count = nearbyStack.stackSize;
            if (item == TinkerTools.openBlocksDevNull) {
                player.inventory.currentItem = itemSlot;
                item.onItemUse(nearbyStack, player, world, x, y, z, side, clickX, clickY, clickZ);
                player.inventory.currentItem = hotbarSlot;
                player.swingItem();
            } else {
                used = item.onItemUse(nearbyStack, player, world, x, y, z, side, clickX, clickY, clickZ);
            }
            if (player.capabilities.isCreativeMode) {
                nearbyStack.setItemDamage(dmg);
                nearbyStack.stackSize = count;
            }
            if (nearbyStack.stackSize < 1) {
                nearbyStack = null;
                player.inventory.setInventorySlotContents(itemSlot, null);
            }
        }
        return used;
    }

    public void breakExtraBlock(World world, int x, int y, int z, int sidehit, EntityPlayer playerEntity, int refX, int refY, int refZ) {
        int meta;
        if (world.isAirBlock(x, y, z)) {
            return;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        Block block = world.getBlock(x, y, z);
        if (!this.isEffective(block, meta = world.getBlockMetadata(x, y, z))) {
            return;
        }
        Block refBlock = world.getBlock(refX, refY, refZ);
        float refStrength = ForgeHooks.blockStrength((Block)refBlock, (EntityPlayer)player, (World)world, (int)refX, (int)refY, (int)refZ);
        float strength = ForgeHooks.blockStrength((Block)block, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta) || refStrength / strength > 10.0f) {
            return;
        }
        BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)player.theItemInWorldManager.getGameType(), (EntityPlayerMP)player, (int)x, (int)y, (int)z);
        if (event.isCanceled()) {
            return;
        }
        if (player.capabilities.isCreativeMode) {
            block.onBlockHarvested(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, false)) {
                block.onBlockDestroyedByPlayer(world, x, y, z, meta);
            }
            if (!world.isRemote) {
                player.playerNetServerHandler.sendPacket((Packet)new S23PacketBlockChange(x, y, z, world));
            }
            return;
        }
        ItemStack currentItem = player.getCurrentEquippedItem();
        if (currentItem != null) {
            currentItem.func_150999_a(world, block, x, y, z, (EntityPlayer)player);
        }
        if (!world.isRemote) {
            block.onBlockHarvested(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.onBlockDestroyedByPlayer(world, x, y, z, meta);
                block.harvestBlock(world, (EntityPlayer)player, x, y, z, meta);
                block.dropXpOnBlockBreak(world, x, y, z, event.getExpToDrop());
            }
            player.playerNetServerHandler.sendPacket((Packet)new S23PacketBlockChange(x, y, z, world));
        } else {
            ItemStack itemstack;
            world.playAuxSFX(2001, x, y, z, Block.getIdFromBlock((Block)block) + (meta << 12));
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.onBlockDestroyedByPlayer(world, x, y, z, meta);
            }
            if ((itemstack = player.getCurrentEquippedItem()) != null) {
                itemstack.func_150999_a(world, block, x, y, z, (EntityPlayer)player);
                if (itemstack.stackSize == 0) {
                    player.destroyCurrentEquippedItem();
                }
            }
            if (PHConstruct.extraBlockUpdates) {
                Minecraft.getMinecraft().getNetHandler().addToSendQueue((Packet)new C07PacketPlayerDigging(2, x, y, z, Minecraft.getMinecraft().objectMouseOver.sideHit));
            }
        }
    }
}

