/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.util;

import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import tconstruct.library.entity.ProjectileBase;
import tconstruct.library.weaponry.IAmmo;

public abstract class BehaviorProjectileBaseDispense
extends BehaviorDefaultDispenseItem {
    public ItemStack dispenseStack(IBlockSource blockSource, ItemStack stack) {
        ItemStack reference;
        World world = blockSource.getWorld();
        IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)blockSource);
        EnumFacing enumfacing = BlockDispenser.func_149937_b((int)blockSource.getBlockMetadata());
        if (stack.getItem() instanceof IAmmo) {
            IAmmo ammo = (IAmmo)stack.getItem();
            if (ammo.getAmmoCount(stack) <= 0) {
                return stack;
            }
            ammo.consumeAmmo(1, stack);
            reference = stack.copy();
            ((IAmmo)reference.getItem()).setAmmo(1, reference);
        } else {
            reference = stack.splitStack(1);
        }
        ProjectileBase projectile = this.getProjectileEntity(world, iposition, reference);
        projectile.setThrowableHeading(enumfacing.getFrontOffsetX(), (float)enumfacing.getFrontOffsetY() + this.ballistic(), enumfacing.getFrontOffsetZ(), this.accuraccy(), this.speed());
        projectile.returnStack = reference;
        projectile.canBePickedUp = 1;
        world.spawnEntityInWorld((Entity)projectile);
        return stack;
    }

    protected void playDispenseSound(IBlockSource p_82485_1_) {
        p_82485_1_.getWorld().playAuxSFX(1002, p_82485_1_.getXInt(), p_82485_1_.getYInt(), p_82485_1_.getZInt(), 0);
    }

    protected abstract ProjectileBase getProjectileEntity(World var1, IPosition var2, ItemStack var3);

    protected float speed() {
        return 6.0f;
    }

    protected float accuraccy() {
        return 1.1f;
    }

    protected float ballistic() {
        return 0.1f;
    }
}

