/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.weaponry;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.tools.TinkerTools;

@Optional.InterfaceList(value={@Optional.Interface(modid="battlegear2", iface="mods.battlegear2.api.weapons.IBattlegearWeapon")})
public abstract class AmmoItem
extends ToolCore
implements IBattlegearWeapon,
IAmmo {
    public AmmoItem(int baseDamage, String name) {
        super(baseDamage);
        this.setCreativeTab(TConstructRegistry.weaponryTab);
    }

    @Override
    public int getAmmoCount(ItemStack stack) {
        if (!stack.hasTagCompound()) {
            return 0;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        return tags.getInteger("Ammo");
    }

    @Override
    public int getMaxAmmo(ItemStack stack) {
        if (!stack.hasTagCompound()) {
            return 0;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        return this.getMaxAmmo(tags);
    }

    @Override
    public int getMaxAmmo(NBTTagCompound tags) {
        float dur = tags.getInteger("TotalDurability");
        return Math.max(1, (int)Math.ceil(dur * this.getAmmoModifier()));
    }

    @Override
    public int addAmmo(int toAdd, ItemStack stack) {
        if (!stack.hasTagCompound()) {
            return toAdd;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        int oldCount = tags.getInteger("Ammo");
        int newCount = Math.min(oldCount + toAdd, this.getMaxAmmo(stack));
        tags.setInteger("Ammo", newCount);
        return toAdd - (newCount - oldCount);
    }

    @Override
    public int consumeAmmo(int toUse, ItemStack stack) {
        if (!stack.hasTagCompound()) {
            return toUse;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        int oldCount = tags.getInteger("Ammo");
        int newCount = Math.max(oldCount - toUse, 0);
        tags.setInteger("Ammo", newCount);
        return toUse - (oldCount - newCount);
    }

    @Override
    public void setAmmo(int count, ItemStack stack) {
        if (!stack.hasTagCompound()) {
            return;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        tags.setInteger("Ammo", count);
    }

    public float getAmmoModifier() {
        return 0.1f;
    }

    public boolean pickupAmmo(ItemStack stack, ItemStack candidate, EntityPlayer player) {
        if (stack.getItem() == null || !stack.hasTagCompound() || !(stack.getItem() instanceof IAmmo)) {
            return false;
        }
        if (candidate != null && this.testIfAmmoMatches(stack, candidate)) {
            IAmmo pickedup = (IAmmo)stack.getItem();
            IAmmo ininventory = (IAmmo)candidate.getItem();
            int count = pickedup.getAmmoCount(stack);
            if (count != ininventory.addAmmo(count, candidate)) {
                return true;
            }
        }
        for (ItemStack invItem : player.inventory.mainInventory) {
            if (!this.testIfAmmoMatches(stack, invItem)) continue;
            IAmmo pickedup = (IAmmo)stack.getItem();
            IAmmo ininventory = (IAmmo)invItem.getItem();
            int count = pickedup.getAmmoCount(stack);
            if (count == ininventory.addAmmo(count, invItem)) continue;
            return true;
        }
        return false;
    }

    private boolean testIfAmmoMatches(ItemStack reference, ItemStack candidate) {
        if (candidate == null) {
            return false;
        }
        if (!candidate.hasTagCompound() || !candidate.getTagCompound().hasKey("InfiTool")) {
            return false;
        }
        if (reference.getItem() != candidate.getItem()) {
            return false;
        }
        NBTTagCompound referenceTags = this.getComparisonTags(reference);
        NBTTagCompound testTags = this.getComparisonTags(candidate);
        return referenceTags.equals((Object)testTags);
    }

    private NBTTagCompound getComparisonTags(ItemStack stack) {
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        NBTTagCompound out = new NBTTagCompound();
        this.copyTag(out, tags, "Head");
        this.copyTag(out, tags, "Handle");
        this.copyTag(out, tags, "Accessory");
        this.copyTag(out, tags, "Extra");
        this.copyTag(out, tags, "RenderHead");
        this.copyTag(out, tags, "RenderHandle");
        this.copyTag(out, tags, "RenderAccessory");
        this.copyTag(out, tags, "RenderExtra");
        this.copyTag(out, tags, "TotalDurability");
        this.copyTag(out, tags, "Attack");
        this.copyTag(out, tags, "MiningSpeed");
        this.copyTag(out, tags, "HarvestLevel");
        this.copyTag(out, tags, "Modifiers");
        return out;
    }

    private void copyTag(NBTTagCompound out, NBTTagCompound in, String tag) {
        if (in.hasKey(tag)) {
            out.setInteger(tag, in.getInteger(tag));
        }
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack item) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean isOffhandHandDual(ItemStack off) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandAttackEntity(PlayerEventChild.OffhandAttackEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        event.cancelParent = false;
        event.swingOffhand = false;
        event.shouldAttack = false;
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        event.setCanceled(false);
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        event.setCanceled(false);
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public void performPassiveEffects(Side effectiveSide, ItemStack mainhandItem, ItemStack offhandItem) {
    }

    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack mainhand, ItemStack offhand) {
        if (offhand == null) {
            return true;
        }
        return mainhand != null && mainhand.getItem() != TinkerTools.cleaver && mainhand.getItem() != TinkerTools.battleaxe && offhand.getItem() != TinkerTools.cleaver && offhand.getItem() != TinkerTools.battleaxe;
    }
}

