/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.mechworks.logic;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityLandmine
extends TileEntity
implements IInventory {
    private ItemStack[] inventory = new ItemStack[this.getSizeInventory()];
    private String containerName;
    public int soundcountythingmax = 10;
    public int soundcountything = 0;
    private boolean shouldUpdateLogic = true;
    public int triggerType;
    public boolean isExploding = false;

    public int getSizeTriggerInventory() {
        return 3;
    }

    public int getSizeInventory() {
        return 4;
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            this.inventory[i].writeToNBT(nbttagcompound1);
            nbttaglist.appendTag((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.setTag("Items", (NBTBase)nbttaglist);
        par1NBTTagCompound.setInteger("triggerType", this.triggerType);
        if (this.hasCustomInventoryName()) {
            par1NBTTagCompound.setString("CustomName", this.containerName);
        }
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.getTagList("Items", 10);
        this.inventory = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
            byte b0 = nbttagcompound1.getByte("Slot");
            if (b0 < 0 || b0 >= this.inventory.length) continue;
            this.inventory[b0] = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound1);
        }
        this.triggerType = par1NBTTagCompound.getInteger("triggerType");
        if (par1NBTTagCompound.hasKey("CustomName")) {
            this.containerName = par1NBTTagCompound.getString("CustomName");
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readFromNBT(packet.func_148857_g());
    }

    public ItemStack getStackInSlot(int i) {
        if (i < this.inventory.length) {
            return this.inventory[i];
        }
        return null;
    }

    public ItemStack decrStackSize(int par1, int par2) {
        if (par1 < this.inventory.length) {
            if (this.inventory[par1] != null) {
                if (this.inventory[par1].stackSize <= par2) {
                    ItemStack itemstack = this.inventory[par1];
                    this.inventory[par1] = null;
                    return itemstack;
                }
                ItemStack itemstack = this.inventory[par1].splitStack(par2);
                if (this.inventory[par1].stackSize == 0) {
                    this.inventory[par1] = null;
                }
                return itemstack;
            }
            return null;
        }
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        if (i < this.inventory.length && this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        if (i < this.inventory.length) {
            this.inventory[i] = itemstack;
        }
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.containerName : "Landmine";
    }

    public boolean hasCustomInventoryName() {
        return this.containerName != null && this.containerName.length() > 0;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void setGuiDisplayName(String par1Str) {
        this.containerName = par1Str;
    }

    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : par1EntityPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public void markDirty() {
        super.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        if (i == 3) {
            return false;
        }
        return false;
    }

    public void setSoundPlayed() {
        this.soundcountything = this.soundcountythingmax = 35;
    }

    public void updateEntity() {
        if (this.shouldUpdateLogic) {
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
            this.shouldUpdateLogic = false;
        }
        if (this.soundcountything > 0) {
            --this.soundcountything;
        }
    }
}

