/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.accessory;

import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import tconstruct.library.accessory.AccessoryCore;
import tconstruct.library.modifier.IModifyable;
import tconstruct.modifiers.tools.ItemModTypeFilter;

public class GloveSpeed
extends ItemModTypeFilter {
    String tooltipName = "\u00a74" + StatCollector.translateToLocal((String)"modifier.tooltip.Haste");
    int max = 100;

    public GloveSpeed(int effect, ItemStack[] items, int[] values) {
        super(effect, "Redstone", items, values);
    }

    @Override
    protected boolean canModify(ItemStack input, ItemStack[] modifiers) {
        if (input.getItem() instanceof AccessoryCore) {
            if (!Arrays.asList(((AccessoryCore)input.getItem()).getTraits()).contains("glove")) {
                return false;
            }
            NBTTagCompound tags = this.getModifierTag(input);
            if (!tags.hasKey(this.key)) {
                return tags.getInteger("Modifiers") > 0 && this.matchingAmount(modifiers) <= this.max;
            }
            int[] keyPair = tags.getIntArray(this.key);
            if (keyPair[0] + this.matchingAmount(modifiers) <= keyPair[1]) {
                return true;
            }
            if (keyPair[0] == keyPair[1]) {
                return tags.getInteger("Modifiers") > 0;
            }
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] modifiers, ItemStack input) {
        int mods;
        NBTTagCompound tags = this.getModifierTag(input);
        int increase = this.matchingAmount(modifiers);
        int current = 0;
        if (tags.hasKey(this.key)) {
            int[] keyPair = tags.getIntArray(this.key);
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.setIntArray(this.key, keyPair);
                mods = tags.getInteger("Modifiers");
                tags.setInteger("Modifiers", --mods);
            } else {
                keyPair[0] = keyPair[0] + increase;
                tags.setIntArray(this.key, keyPair);
            }
            current = keyPair[0];
            this.updateModTag(input, keyPair);
        } else {
            mods = tags.getInteger("Modifiers");
            tags.setInteger("Modifiers", --mods);
            String modName = "\u00a74Redstone (" + increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(input, this.tooltipName, modName);
            int[] keyPair = new int[]{increase, this.max, tooltipIndex};
            current = keyPair[0];
            tags.setIntArray(this.key, keyPair);
        }
        int miningSpeed = tags.getInteger("MiningSpeed");
        int boost = 1;
        tags.setInteger("MiningSpeed", miningSpeed += increase * boost);
    }

    void updateModTag(ItemStack input, int[] keys) {
        NBTTagCompound tags = this.getModifierTag(input);
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a74Redstone (" + keys[0] + "/" + keys[1] + ")";
        tags.setString(tip, modName);
    }

    @Override
    public boolean validType(IModifyable type) {
        return type.getModifyType().equals("Accessory");
    }
}

