/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.armor;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tconstruct.library.armor.ArmorPart;
import tconstruct.modifiers.armor.AModBoolean;

public class AModLeadBoots
extends AModBoolean {
    private static final UUID shoes = UUID.fromString("4188779d-69d4-487c-b307-c4c182522c47");

    public AModLeadBoots(ItemStack[] items) {
        super(2, "LeadBoots", EnumSet.of(ArmorPart.Feet), items, "\u00a78", "Lead Boots");
    }

    @Override
    public void modify(ItemStack[] recipe, ItemStack armor) {
        NBTTagList attributes;
        NBTTagCompound baseTag = armor.getTagCompound();
        NBTTagCompound armorTag = armor.getTagCompound().getCompoundTag(this.getTagName(armor));
        armorTag.setBoolean(this.key, true);
        int modifiers = armorTag.getInteger("Modifiers");
        armorTag.setInteger("Modifiers", --modifiers);
        this.addToolTip(armor, this.color + this.tooltipName, this.color + this.key);
        if (baseTag.hasKey("AttributeModifiers")) {
            attributes = baseTag.getTagList("AttributeModifiers", 0);
            for (int iter = 0; iter < attributes.tagCount(); ++iter) {
                NBTTagCompound tag = attributes.getCompoundTagAt(iter);
                if (!tag.getString("AttributeName").equals("generic.knockbackResistance")) continue;
                attributes.removeTag(iter);
            }
        } else {
            attributes = new NBTTagList();
            baseTag.setTag("AttributeModifiers", (NBTBase)attributes);
        }
        attributes.appendTag((NBTBase)AModLeadBoots.getAttributeTag("generic.knockbackResistance", this.key, 0.4, true, shoes));
    }
}

