/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ItemModTypeFilter;

public class ModAttack
extends ItemModTypeFilter {
    String tooltipName;
    int max;
    int threshold;
    String guiType;
    String modifierType;
    boolean ammoOnly;

    public ModAttack(String type, int effect, ItemStack[] items, int[] value) {
        super(effect, "ModAttack", items, value);
        this.tooltipName = "\u00a7fSharpness";
        this.guiType = type;
        this.max = 72;
        this.threshold = 24;
        this.modifierType = "Tool";
        this.ammoOnly = false;
    }

    public ModAttack(String type, int effect, ItemStack[] items, int[] value, boolean ammoOnly) {
        super(effect, "ModAttack", items, value);
        this.tooltipName = "\u00a7fSharpness";
        this.guiType = type;
        this.max = 48;
        this.threshold = 24;
        this.modifierType = "Tool";
        this.ammoOnly = ammoOnly;
    }

    public ModAttack(String type, int effect, ItemStack[] items, int[] value, int max, int threshold, String modifierType) {
        super(effect, "ModAttack", items, value);
        this.tooltipName = "\u00a7fKnuckles";
        this.guiType = type;
        this.max = max;
        this.threshold = threshold;
        this.modifierType = modifierType;
        this.ammoOnly = false;
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        if (tool.getItem() instanceof ToolCore && Arrays.asList(((ToolCore)tool.getItem()).getTraits()).contains("ammo") != this.ammoOnly) {
            return false;
        }
        if (tool.getItem() instanceof IModifyable) {
            IModifyable toolItem = (IModifyable)tool.getItem();
            if (!this.validType(toolItem)) {
                return false;
            }
            if (this.matchingAmount(input) > this.max) {
                return false;
            }
            NBTTagCompound tags = tool.getTagCompound().getCompoundTag(toolItem.getBaseTagName());
            if (!tags.hasKey(this.key)) {
                return tags.getInteger("Modifiers") > 0 && this.matchingAmount(input) <= this.max;
            }
            int[] keyPair = tags.getIntArray(this.key);
            if (keyPair[0] + this.matchingAmount(input) <= keyPair[1]) {
                return true;
            }
            if (keyPair[0] == keyPair[1]) {
                return tags.getInteger("Modifiers") > 0;
            }
        }
        return false;
    }

    @Override
    public boolean validType(IModifyable input) {
        String type = input.getModifyType();
        return type.equals(this.modifierType);
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        IModifyable toolItem = (IModifyable)tool.getItem();
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag(toolItem.getBaseTagName());
        if (tags.hasKey(this.key)) {
            int leftToBoost;
            int[] keyPair = tags.getIntArray(this.key);
            int increase = this.matchingAmount(input);
            if (increase >= (leftToBoost = this.threshold - keyPair[0] % this.threshold)) {
                int attack = tags.getInteger("Attack");
                tags.setInteger("Attack", ++attack);
            }
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.setIntArray(this.key, keyPair);
                int modifiers = tags.getInteger("Modifiers");
                tags.setInteger("Modifiers", --modifiers);
            } else {
                keyPair[0] = keyPair[0] + increase;
                tags.setIntArray(this.key, keyPair);
            }
            this.updateModTag(tool, keyPair);
        } else {
            int modifiers = tags.getInteger("Modifiers");
            tags.setInteger("Modifiers", --modifiers);
            int increase = this.matchingAmount(input);
            String modName = "\u00a7f" + this.guiType + " (" + increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            int[] keyPair = new int[]{increase, this.max, tooltipIndex};
            tags.setIntArray(this.key, keyPair);
            int attack = tags.getInteger("Attack");
            tags.setInteger("Attack", ++attack);
        }
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag(this.getTagName(tool));
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a7f" + this.guiType + " (" + keys[0] + "/" + keys[1] + ")";
        tags.setString(tip, modName);
    }
}

