/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ItemModTypeFilter;

public class ModBlaze
extends ItemModTypeFilter {
    String tooltipName = "\u00a76Fiery";
    int max = 25;

    public ModBlaze(int effect, ItemStack[] items, int[] values) {
        super(effect, "Blaze", items, values);
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        if (tool.getItem() instanceof ToolCore) {
            ToolCore toolItem = (ToolCore)tool.getItem();
            if (!this.validType(toolItem)) {
                return false;
            }
            if (this.matchingAmount(input) > this.max) {
                return false;
            }
            NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
            if (!tags.hasKey(this.key)) {
                return tags.getInteger("Modifiers") > 0 && this.matchingAmount(input) <= this.max;
            }
            int[] keyPair = tags.getIntArray(this.key);
            if (keyPair[0] + this.matchingAmount(input) <= keyPair[1]) {
                return true;
            }
            if (keyPair[0] == keyPair[1]) {
                return tags.getInteger("Modifiers") > 0;
            }
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        int increase = this.matchingAmount(input);
        if (tags.hasKey(this.key)) {
            int[] keyPair = tags.getIntArray(this.key);
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.setIntArray(this.key, keyPair);
                int modifiers = tags.getInteger("Modifiers");
                tags.setInteger("Modifiers", --modifiers);
            } else {
                keyPair[0] = keyPair[0] + increase;
                tags.setIntArray(this.key, keyPair);
            }
            this.updateModTag(tool, keyPair);
        } else {
            int modifiers = tags.getInteger("Modifiers");
            tags.setInteger("Modifiers", --modifiers);
            String modName = "\u00a76Blaze (" + increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            int[] keyPair = new int[]{increase, this.max, tooltipIndex};
            tags.setIntArray(this.key, keyPair);
        }
        int fiery = tags.getInteger("Fiery");
        tags.setInteger("Fiery", fiery += increase);
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a76Blaze (" + keys[0] + "/" + keys[1] + ")";
        tags.setString(tip, modName);
    }

    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.getTraits());
        return list.contains("melee") || list.contains("ammo");
    }
}

