/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ItemModTypeFilter;

public class ModLapis
extends ItemModTypeFilter {
    String tooltipName = "\u00a79Luck";
    int max = 450;

    public ModLapis(int effect, ItemStack[] items, int[] values) {
        super(effect, "Lapis", items, values);
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        if (tool.getItem() instanceof ToolCore) {
            ToolCore toolItem = (ToolCore)tool.getItem();
            if (!this.validType(toolItem)) {
                return false;
            }
            if (this.matchingAmount(input) > this.max) {
                return false;
            }
            NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
            if (tags.getBoolean("Silk Touch")) {
                return false;
            }
            if (!tags.hasKey(this.key)) {
                return tags.getInteger("Modifiers") > 0 && this.matchingAmount(input) <= this.max;
            }
            int[] keyPair = tags.getIntArray(this.key);
            if (keyPair[0] + this.matchingAmount(input) <= this.max) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        if (!tags.hasKey(this.key)) {
            tags.setBoolean(this.key, true);
            String modName = "\u00a79Lapis (0/450)";
            int tooltipIndex = this.addToolTip(tool, "\u00a79Luck", modName);
            int[] keyPair = new int[]{0, tooltipIndex};
            tags.setIntArray(this.key, keyPair);
            int modifiers = tags.getInteger("Modifiers");
            tags.setInteger("Modifiers", --modifiers);
        }
        int increase = this.matchingAmount(input);
        int[] keyPair = tags.getIntArray(this.key);
        keyPair[0] = keyPair[0] + increase;
        tags.setIntArray(this.key, keyPair);
        ToolCore toolcore = (ToolCore)tool.getItem();
        String[] types = toolcore.getTraits();
        boolean weapon = false;
        boolean harvest = false;
        for (String s : types) {
            if (s.equals("harvest")) {
                harvest = true;
                continue;
            }
            if (!s.equals("weapon")) continue;
            weapon = true;
        }
        if (weapon) {
            if (keyPair[0] >= 450) {
                this.addEnchantment(tool, Enchantment.looting, 3);
            } else if (keyPair[0] >= 300) {
                this.addEnchantment(tool, Enchantment.looting, 2);
            } else if (keyPair[0] >= 100) {
                this.addEnchantment(tool, Enchantment.looting, 1);
            }
        }
        if (harvest) {
            if (keyPair[0] >= 450) {
                this.addEnchantment(tool, Enchantment.fortune, 3);
            } else if (keyPair[0] >= 300) {
                this.addEnchantment(tool, Enchantment.fortune, 2);
            } else if (keyPair[0] >= 100) {
                this.addEnchantment(tool, Enchantment.fortune, 1);
            }
        }
        this.updateModTag(tool, keyPair);
    }

    public void midStreamModify(ItemStack tool, ToolCore toolItem) {
        int chance;
        List<String> list;
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        if (!tags.hasKey(this.key)) {
            return;
        }
        int[] keyPair = tags.getIntArray(this.key);
        if (keyPair[0] == this.max) {
            return;
        }
        if (random.nextInt(50) == 0) {
            keyPair[0] = keyPair[0] + 1;
            tags.setIntArray(this.key, keyPair);
            this.updateModTag(tool, keyPair);
        }
        if ((list = Arrays.asList(toolItem.getTraits())).contains("weapon")) {
            if (keyPair[0] >= 450) {
                this.addEnchantment(tool, Enchantment.looting, 3);
            } else if (keyPair[0] >= 350) {
                chance = keyPair[0] - 300;
                if (random.nextInt(1000 - chance) == 0) {
                    this.addEnchantment(tool, Enchantment.looting, 3);
                }
            } else if (keyPair[0] >= 125) {
                chance = keyPair[0] - 175;
                if (random.nextInt(600 - chance) == 0) {
                    this.addEnchantment(tool, Enchantment.looting, 2);
                }
            } else if (keyPair[0] >= 10 && random.nextInt(250 - (chance = keyPair[0] - 25)) == 0) {
                this.addEnchantment(tool, Enchantment.looting, 1);
            }
        }
        if (list.contains("harvest")) {
            if (keyPair[0] >= 450) {
                this.addEnchantment(tool, Enchantment.fortune, 3);
            } else if (keyPair[0] >= 350) {
                chance = keyPair[0] - 300;
                if (random.nextInt(1000 - chance) == 0) {
                    this.addEnchantment(tool, Enchantment.fortune, 3);
                }
            } else if (keyPair[0] >= 125) {
                chance = keyPair[0] - 175;
                if (random.nextInt(600 - chance) == 0) {
                    this.addEnchantment(tool, Enchantment.fortune, 2);
                }
            } else if (keyPair[0] >= 10 && random.nextInt(250 - (chance = keyPair[0] - 25)) == 0) {
                this.addEnchantment(tool, Enchantment.fortune, 1);
            }
        }
    }

    public void addEnchantment(ItemStack tool, Enchantment enchant, int level) {
        NBTTagCompound enchantTag;
        NBTTagList tags = new NBTTagList();
        Map enchantMap = EnchantmentHelper.getEnchantments((ItemStack)tool);
        Iterator iterator = enchantMap.keySet().iterator();
        boolean hasEnchant = false;
        while (iterator.hasNext()) {
            enchantTag = new NBTTagCompound();
            int index = (Integer)iterator.next();
            int lvl = (Integer)enchantMap.get(index);
            if (index == enchant.effectId) {
                hasEnchant = true;
                enchantTag.setShort("id", (short)index);
                enchantTag.setShort("lvl", (short)((byte)level));
                tags.appendTag((NBTBase)enchantTag);
                continue;
            }
            enchantTag.setShort("id", (short)index);
            enchantTag.setShort("lvl", (short)((byte)lvl));
            tags.appendTag((NBTBase)enchantTag);
        }
        if (!hasEnchant) {
            enchantTag = new NBTTagCompound();
            enchantTag.setShort("id", (short)enchant.effectId);
            enchantTag.setShort("lvl", (short)((byte)level));
            tags.appendTag((NBTBase)enchantTag);
        }
        tool.stackTagCompound.setTag("ench", (NBTBase)tags);
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        String tip = "ModifierTip" + keys[1];
        String modName = "\u00a79Lapis (" + keys[0] + "/" + this.max + ")";
        tags.setString(tip, modName);
    }

    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.getTraits());
        return !list.contains("ammo") && (list.contains("weapon") || list.contains("harvest"));
    }
}

