/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ItemModTypeFilter;

public class ModRedstone
extends ItemModTypeFilter {
    public String tooltipName = "\u00a74Haste";
    public int max = 50;

    public ModRedstone(int effect, ItemStack[] items, int[] values) {
        super(effect, "Redstone", items, values);
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        if (tool.getItem() instanceof ToolCore) {
            ToolCore toolItem = (ToolCore)tool.getItem();
            if (!this.validType(toolItem)) {
                return false;
            }
            if (this.matchingAmount(input) > this.max) {
                return false;
            }
            NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
            if (!tags.hasKey(this.key)) {
                return tags.getInteger("Modifiers") > 0 && this.matchingAmount(input) <= this.max;
            }
            int[] keyPair = tags.getIntArray(this.key);
            if (keyPair[0] + this.matchingAmount(input) <= keyPair[1]) {
                return true;
            }
            if (keyPair[0] == keyPair[1]) {
                return tags.getInteger("Modifiers") > 0;
            }
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        int modifiers;
        int[] keyPair;
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        int increase = this.matchingAmount(input);
        int current = 0;
        if (tags.hasKey(this.key)) {
            keyPair = tags.getIntArray(this.key);
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.setIntArray(this.key, keyPair);
                modifiers = tags.getInteger("Modifiers");
                tags.setInteger("Modifiers", --modifiers);
            } else {
                keyPair[0] = keyPair[0] + increase;
                tags.setIntArray(this.key, keyPair);
            }
            current = keyPair[0];
            this.updateModTag(tool, keyPair);
        } else {
            modifiers = tags.getInteger("Modifiers");
            tags.setInteger("Modifiers", --modifiers);
            String modName = "\u00a74Redstone (" + increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            keyPair = new int[]{increase, this.max, tooltipIndex};
            current = keyPair[0];
            tags.setIntArray(this.key, keyPair);
        }
        int miningSpeed = tags.getInteger("MiningSpeed");
        int boost = 8 + (current - 1) / 50 * 2;
        Item temp = tool.getItem();
        if (temp instanceof ToolCore) {
            ToolCore toolcore = (ToolCore)temp;
            if (toolcore.durabilityTypeHandle() == 2) {
                boost += 2;
            }
            if (toolcore.durabilityTypeAccessory() == 2) {
                boost += 2;
            }
            if (toolcore.durabilityTypeExtra() == 2) {
                boost += 2;
            }
        }
        tags.setInteger("MiningSpeed", miningSpeed += increase * boost);
        String[] type = new String[]{"MiningSpeed2", "MiningSpeedHandle", "MiningSpeedExtra"};
        for (int i = 0; i < 3; ++i) {
            if (!tags.hasKey(type[i])) continue;
            int speed = tags.getInteger(type[i]);
            tags.setInteger(type[i], speed += increase * boost);
        }
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a74Redstone (" + keys[0] + "/" + keys[1] + ")";
        tags.setString(tip, modName);
    }

    @Override
    public boolean validType(IModifyable input) {
        return input.getModifyType().equals("Tool");
    }

    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.getTraits());
        if (list.contains("windup")) {
            return false;
        }
        return list.contains("harvest") || list.contains("utility");
    }
}

