/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.blocks;

import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import tconstruct.smeltery.blocks.TConstructFluid;

public class PigIronMoltenBlock
extends TConstructFluid {
    public PigIronMoltenBlock(Fluid fluid, Material material, String texture) {
        super(fluid, material, texture);
    }

    @Override
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.stillIcon = iconRegister.registerIcon("tinker:" + this.texture);
        this.flowIcon = iconRegister.registerIcon("tinker:" + this.texture);
        if (this.overwriteFluidIcons) {
            this.getFluid().setIcons(this.stillIcon, this.flowIcon);
        }
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (!world.isRemote && entity != null && !entity.isWet()) {
            entity.setFire(40);
        }
        if (!entity.isWet() || world.rand.nextInt(100) > 73) {
            world.playSoundAtEntity(entity, "random.fizz", 0.7f, 1.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.4f);
        }
    }
}

