/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.itemblocks;

import java.util.List;
import mantle.blocks.abstracts.MultiItemBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GlassBlockItem
extends MultiItemBlock {
    public static final String[] blockTypes = new String[]{"pure"};

    public GlassBlockItem(Block b) {
        super(b, "block.glass", blockTypes);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (stack.hasTagCompound() && stack.getItemDamage() == 0) {
            ItemStack camo;
            NBTTagCompound camoTag;
            ItemStack contents;
            NBTTagCompound contentTags = stack.getTagCompound().getCompoundTag("Contents");
            if (contentTags != null && (contents = ItemStack.loadItemStackFromNBT((NBTTagCompound)contentTags)) != null) {
                list.add("Inventory: " + contents.getDisplayName());
                list.add("Amount: " + contents.stackSize);
            }
            if ((camoTag = stack.getTagCompound().getCompoundTag("Camoflauge")) != null && (camo = ItemStack.loadItemStackFromNBT((NBTTagCompound)camoTag)) != null) {
                list.add("Camoflauge: " + camo.getDisplayName());
            }
            if (stack.getTagCompound().hasKey("Placement")) {
                String string = this.getDirectionString(stack.getTagCompound().getByte("Placement"));
                list.add("Placement Direction: " + string);
            }
        }
    }

    String getDirectionString(byte key) {
        if (key == 0) {
            return "Up";
        }
        if (key == 1) {
            return "Right";
        }
        if (key == 2) {
            return "Down";
        }
        return "Left";
    }
}

