/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.model;

import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import tconstruct.smeltery.model.TankRender;
import tconstruct.util.ItemHelper;

public class TankItemRenderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        FluidStack liquid;
        RenderBlocks renderblocks = (RenderBlocks)data[0];
        Block block = Block.getBlockFromItem((Item)item.getItem());
        int meta = item.getItemDamage();
        if (item.hasTagCompound() && item.getTagCompound().hasKey("Fluid") && (liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)item.getTagCompound().getCompoundTag("Fluid"))) != null && liquid.getFluid().getBlock() != null) {
            GL11.glEnable((int)3042);
            float height = (float)liquid.amount / 4000.0f - 0.01f;
            renderblocks.setRenderBounds(0.01, 0.01, 0.01, 0.99, (double)height, 0.99);
            ItemHelper.renderStandardInvBlock(renderblocks, liquid.getFluid().getBlock(), 0);
            GL11.glDisable((int)3042);
        }
        GL11.glEnable((int)3008);
        renderblocks.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        RenderingRegistry.instance().renderInventoryBlock(renderblocks, block, meta, TankRender.tankModelID);
        GL11.glDisable((int)3008);
    }
}

