/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mantle.blocks.abstracts.InventorySlab;
import mantle.blocks.iface.IActiveLogic;
import mantle.blocks.iface.IFacingLogic;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.tools.logic.FurnaceLogic;

public class FurnaceSlab
extends InventorySlab {
    public FurnaceSlab(Material material) {
        super(material);
        this.setCreativeTab(TConstructRegistry.blockTab);
        this.setHardness(3.5f);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata % 8) {
            case 0: {
                return new FurnaceLogic();
            }
        }
        return null;
    }

    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return 8;
    }

    public Object getModInstance() {
        return TConstruct.instance;
    }

    public String[] getTextureNames() {
        String[] textureNames = new String[]{"furnaceslab_front", "furnaceslab_front_active", "furnaceslab_side", "furnace_top"};
        return textureNames;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.icons[meta % 8 * 3 + this.getTextureIndex(side)];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.getTileEntity(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.getBlockMetadata(x, y, z) % 8;
        if (meta == 0) {
            if (side == direction) {
                if (((IActiveLogic)logic).getActive()) {
                    return this.icons[1];
                }
                return this.icons[0];
            }
            if (side > 1) {
                return this.icons[2];
            }
            return this.icons[3];
        }
        return this.icons[0];
    }

    public int getTextureIndex(int side) {
        if (side == 0 || side == 1) {
            return 3;
        }
        if (side == 3) {
            return 0;
        }
        return 2;
    }

    public String getTextureDomain(int textureNameIndex) {
        return "tinker";
    }

    public void registerBlockIcons(IIconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new IIcon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = i == 3 ? iconRegister.registerIcon("minecraft:" + textureNames[i]) : iconRegister.registerIcon("tinker:" + textureNames[i]);
        }
    }

    public TileEntity createNewTileEntity(World var1, int metadata) {
        switch (metadata % 8) {
            case 0: {
                return new FurnaceLogic();
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        TileEntity logic = world.getTileEntity(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.getBlockMetadata(x, y, z);
        int metaType = meta % 8;
        int metaPos = meta / 8;
        if (metaType == 0 && ((IActiveLogic)logic).getActive()) {
            float offset = random.nextFloat() * 0.6f - 0.3f;
            float offsetY = random.nextFloat() * 6.0f / 16.0f;
            if (metaPos == 1) {
                offsetY += 0.5f;
            }
            if (direction == 4) {
                world.spawnParticle("smoke", (double)((float)x - 0.02f), (double)((float)y + offsetY), (double)((float)z + offset + 0.5f), 0.0, 0.0, 0.0);
                world.spawnParticle("flame", (double)((float)x - 0.02f), (double)((float)y + offsetY), (double)((float)z + offset + 0.5f), 0.0, 0.0, 0.0);
            } else if (direction == 5) {
                world.spawnParticle("smoke", (double)((float)x + 1.02f), (double)((float)y + offsetY), (double)((float)z + offset + 0.5f), 0.0, 0.0, 0.0);
                world.spawnParticle("flame", (double)((float)x + 1.02f), (double)((float)y + offsetY), (double)((float)z + offset + 0.5f), 0.0, 0.0, 0.0);
            } else if (direction == 2) {
                world.spawnParticle("smoke", (double)((float)x + offset + 0.5f), (double)((float)y + offsetY), (double)((float)z - 0.02f), 0.0, 0.0, 0.0);
                world.spawnParticle("flame", (double)((float)x + offset + 0.5f), (double)((float)y + offsetY), (double)((float)z - 0.02f), 0.0, 0.0, 0.0);
            } else if (direction == 3) {
                world.spawnParticle("smoke", (double)((float)x + offset + 0.5f), (double)((float)y + offsetY), (double)((float)z + 1.02f), 0.0, 0.0, 0.0);
                world.spawnParticle("flame", (double)((float)x + offset + 0.5f), (double)((float)y + offsetY), (double)((float)z + 1.02f), 0.0, 0.0, 0.0);
            }
        }
    }
}

