/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.gui;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import tconstruct.library.accessory.AccessoryCore;
import tconstruct.library.armor.ArmorCore;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.util.HarvestLevels;
import tconstruct.library.weaponry.AmmoWeapon;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.library.weaponry.ProjectileWeapon;

public final class ToolStationGuiHelper {
    private static final FontRenderer fontRendererObj = Minecraft.getMinecraft().fontRenderer;
    private static int xPos;
    private static int yPos;
    private static final DecimalFormat df;

    private ToolStationGuiHelper() {
    }

    private static void newline() {
        yPos += 10;
    }

    private static void write(String s) {
        fontRendererObj.drawString(s, xPos, yPos, -1);
        ToolStationGuiHelper.newline();
    }

    public static void drawToolStats(ItemStack stack, int x, int y) {
        String name = stack.getItem() instanceof ToolCore ? ((ToolCore)stack.getItem()).getLocalizedToolName() : stack.getDisplayName();
        Item item = stack.getItem();
        NBTTagCompound tags = stack.getTagCompound();
        List<Object> categories = new LinkedList();
        xPos = x;
        yPos = y + 8;
        if (item instanceof IModifyable) {
            IModifyable modifyable = (IModifyable)item;
            tags = tags.getCompoundTag(modifyable.getBaseTagName());
            categories = Arrays.asList(modifyable.getTraits());
        }
        ToolStationGuiHelper.drawCenteredString(fontRendererObj, "\u00a7n" + name, xPos + 55, yPos, -1);
        ToolStationGuiHelper.newline();
        ToolStationGuiHelper.newline();
        if (item instanceof IAmmo) {
            ToolStationGuiHelper.drawAmmo((IAmmo)item, stack);
        } else if (item instanceof ToolCore || item instanceof ArmorCore) {
            ToolStationGuiHelper.drawDurability(tags);
        }
        if (item instanceof ToolCore) {
            ToolCore tool = (ToolCore)item;
            if (categories.contains("dualharvest")) {
                ToolStationGuiHelper.drawDualHarvestStats(tool, tags);
            } else if (categories.contains("harvest")) {
                ToolStationGuiHelper.drawHarvestStats(tool, tags);
            }
            if (categories.contains("weapon")) {
                ToolStationGuiHelper.drawWeaponStats(tool, tags);
            }
            if (categories.contains("thrown") && tool instanceof AmmoWeapon) {
                ToolStationGuiHelper.drawThrowingWeaponStats((AmmoWeapon)tool, tags);
            }
            if (categories.contains("bow") && tool instanceof ProjectileWeapon) {
                ToolStationGuiHelper.drawProjectileWeaponStats((ProjectileWeapon)tool, tags, stack);
            }
            if (categories.contains("projectile")) {
                ToolStationGuiHelper.drawProjectileStats(tags);
            }
        }
        if (item instanceof ArmorCore) {
            ArmorCore armor = (ArmorCore)item;
            ToolStationGuiHelper.drawArmorStats(armor, tags, stack);
        }
        if (item instanceof AccessoryCore) {
            AccessoryCore accessory = (AccessoryCore)item;
            ToolStationGuiHelper.drawAccessoryStats(accessory, tags);
        }
        ToolStationGuiHelper.newline();
        ToolStationGuiHelper.drawModifiers(tags);
    }

    private static void drawDurability(NBTTagCompound tags) {
        int durability = tags.getInteger("Damage");
        int maxDur = tags.getInteger("TotalDurability");
        int availableDurability = maxDur - durability;
        if (maxDur >= 10000) {
            ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation1"));
            ToolStationGuiHelper.write("- " + availableDurability + "/" + maxDur);
        } else {
            ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation2") + availableDurability + "/" + maxDur);
        }
    }

    private static void drawAmmo(IAmmo ammoItem, ItemStack stack) {
        int max = ammoItem.getMaxAmmo(stack);
        int current = ammoItem.getAmmoCount(stack);
        ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation21") + current + "/" + max);
    }

    private static void drawModifiers(NBTTagCompound tags) {
        int modifiers = tags.getInteger("Modifiers");
        if (modifiers != 0) {
            ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation18") + modifiers);
        }
        if (tags.hasKey("ModifierTip1")) {
            ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation17"));
            String tooltip = "ModifierTip";
            int tipNum = 1;
            while (tags.hasKey(tooltip + tipNum)) {
                String tipName = tags.getString(tooltip + tipNum);
                String locString = "modifier.toolstation." + tipName;
                int bracket = tipName.indexOf("(");
                if (bracket > 0) {
                    locString = "modifier.toolstation." + tipName.substring(0, bracket);
                }
                if (StatCollector.canTranslate((String)(locString = EnumChatFormatting.getTextWithoutFormattingCodes((String)locString.replace(" ", ""))))) {
                    tipName = tipName.replace(EnumChatFormatting.getTextWithoutFormattingCodes((String)tipName), StatCollector.translateToLocal((String)locString));
                    if (bracket > 0) {
                        tipName = tipName + " " + tags.getString(tooltip + tipNum).substring(bracket);
                    }
                }
                ToolStationGuiHelper.write("- " + tipName);
                ++tipNum;
            }
        }
    }

    private static void drawHarvestStats(ToolCore tool, NBTTagCompound tags) {
        float mineSpeed = AbilityHelper.calcToolSpeed(tool, tags);
        float stoneboundSpeed = AbilityHelper.calcStoneboundBonus(tool, tags);
        ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation14") + df.format(mineSpeed));
        if (stoneboundSpeed != 0.0f) {
            String bloss = stoneboundSpeed > 0.0f ? StatCollector.translateToLocal((String)"gui.toolstation4") : StatCollector.translateToLocal((String)"gui.toolstation5");
            ToolStationGuiHelper.write(bloss + df.format(stoneboundSpeed));
        }
        ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation15") + HarvestLevels.getHarvestLevelName(tags.getInteger("HarvestLevel")));
    }

    private static void drawDualHarvestStats(ToolCore tool, NBTTagCompound tags) {
        float mineSpeed = AbilityHelper.calcDualToolSpeed(tool, tags, false);
        float mineSpeed2 = AbilityHelper.calcDualToolSpeed(tool, tags, true);
        float stoneboundSpeed = AbilityHelper.calcStoneboundBonus(tool, tags);
        ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation12"));
        ToolStationGuiHelper.write("- " + df.format(mineSpeed) + ", " + df.format(mineSpeed2));
        if (stoneboundSpeed != 0.0f) {
            String bloss = stoneboundSpeed > 0.0f ? StatCollector.translateToLocal((String)"gui.toolstation4") : StatCollector.translateToLocal((String)"gui.toolstation5");
            ToolStationGuiHelper.write(bloss + df.format(stoneboundSpeed));
        }
        ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation13"));
        ToolStationGuiHelper.write("- " + HarvestLevels.getHarvestLevelName(tags.getInteger("HarvestLevel")) + ", " + HarvestLevels.getHarvestLevelName(tags.getInteger("HarvestLevel2")));
    }

    private static void drawWeaponStats(ToolCore tool, NBTTagCompound tags) {
        String heart;
        int attack = tags.getInteger("Attack");
        float stoneboundDamage = -AbilityHelper.calcStoneboundBonus(tool, tags);
        attack = (int)((float)attack + stoneboundDamage);
        if ((attack = (int)((float)attack * tool.getDamageModifier())) < 1) {
            attack = 1;
        }
        String string = heart = attack == 2 ? StatCollector.translateToLocal((String)"gui.partcrafter8") : StatCollector.translateToLocal((String)"gui.partcrafter9");
        if (attack % 2 == 0) {
            ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation3") + attack / 2 + heart);
        } else {
            ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation3") + df.format((float)attack / 2.0f) + heart);
        }
        if (stoneboundDamage != 0.0f) {
            heart = stoneboundDamage == 2.0f ? StatCollector.translateToLocal((String)"gui.partcrafter8") : StatCollector.translateToLocal((String)"gui.partcrafter9");
            String bloss = stoneboundDamage > 0.0f ? StatCollector.translateToLocal((String)"gui.toolstation4") : StatCollector.translateToLocal((String)"gui.toolstation5");
            ToolStationGuiHelper.write(bloss + df.format(stoneboundDamage / 2.0f) + heart);
        }
    }

    private static void drawThrowingWeaponStats(AmmoWeapon weapon, NBTTagCompound tags) {
        int attack;
        String heart;
        float attackf = tags.getInteger("Attack");
        attackf *= weapon.getDamageModifier();
        if ((attackf *= weapon.getProjectileSpeed()) < 1.0f) {
            attackf = 1.0f;
        }
        String string = heart = (attack = (int)attackf) == 2 ? StatCollector.translateToLocal((String)"gui.partcrafter8") : StatCollector.translateToLocal((String)"gui.partcrafter9");
        if (attack % 2 == 0) {
            ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation23") + attack / 2 + heart);
        } else {
            ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation23") + df.format((float)attack / 2.0f) + heart);
        }
    }

    private static void drawProjectileWeaponStats(ProjectileWeapon weapon, NBTTagCompound tags, ItemStack stack) {
        int drawSpeed = weapon.getWindupTime(stack);
        float trueDraw = (float)drawSpeed / 20.0f;
        ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation6") + df.format(trueDraw) + "s");
        float flightSpeed = weapon.getProjectileSpeed(stack);
        ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation7") + df.format(flightSpeed) + "x");
    }

    private static void drawProjectileStats(NBTTagCompound tags) {
        float weight = tags.getFloat("Mass");
        ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation8") + df.format(weight));
        float accuracy = tags.getFloat("Accuracy");
        ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation9") + df.format(accuracy) + "%");
        float breakChance = tags.getFloat("BreakChance") * 100.0f;
        ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation22") + df.format(breakChance) + "%");
    }

    private static void drawArmorStats(ArmorCore armor, NBTTagCompound tags, ItemStack stack) {
        double damageReduction = tags.getDouble("DamageReduction");
        if (damageReduction > 0.0) {
            ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation19") + df.format(damageReduction));
        }
        double protection = armor.getProtection(stack);
        double maxProtection = tags.getDouble("MaxDefense");
        ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation20") + df.format(protection) + "/" + df.format(maxProtection));
    }

    private static void drawAccessoryStats(AccessoryCore core, NBTTagCompound tags) {
        if (tags.hasKey("MiningSpeed")) {
            float mineSpeed = tags.getInteger("MiningSpeed");
            float trueSpeed = mineSpeed / 100.0f;
            ToolStationGuiHelper.write(StatCollector.translateToLocal((String)"gui.toolstation16") + trueSpeed);
        }
    }

    public static void drawCenteredString(FontRenderer p_73732_1_, String p_73732_2_, int p_73732_3_, int p_73732_4_, int p_73732_5_) {
        p_73732_1_.drawStringWithShadow(p_73732_2_, p_73732_3_ - p_73732_1_.getStringWidth(p_73732_2_) / 2, p_73732_4_, p_73732_5_);
    }

    static {
        df = new DecimalFormat("#.##");
    }
}

