/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.inventory;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.inventory.SlotFrypan;
import tconstruct.tools.logic.FrypanLogic;

public class FrypanContainer
extends Container {
    public FrypanLogic logic;
    public int progress = 0;
    public int fuel = 0;
    public int fuelGague = 0;

    public FrypanContainer(EntityPlayer player, FrypanLogic frypan) {
        int column;
        InventoryPlayer inventoryplayer = player.inventory;
        this.logic = frypan;
        this.addSlotToContainer(new Slot((IInventory)frypan, 1, 26, 45));
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 4; ++x) {
                this.addSlotToContainer(new SlotFrypan((IInventory)frypan, 2 + x + y * 4, 70 + x * 18, 27 + y * 18, player));
            }
        }
        for (column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.addSlotToContainer(new Slot((IInventory)inventoryplayer, row + column * 9 + 9, 8 + row * 18, 84 + column * 18));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlotToContainer(new Slot((IInventory)inventoryplayer, column, 8 + column * 18, 142));
        }
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int i = 0; i < this.crafters.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.crafters.get(i);
            if (this.progress != this.logic.progress) {
                icrafting.sendProgressBarUpdate((Container)this, 0, this.logic.progress);
            }
            if (this.fuel != this.logic.fuel) {
                icrafting.sendProgressBarUpdate((Container)this, 1, this.logic.fuel);
            }
            if (this.fuelGague == this.logic.fuelGague) continue;
            icrafting.sendProgressBarUpdate((Container)this, 2, this.logic.fuelGague);
        }
        this.progress = this.logic.progress;
        this.fuel = this.logic.fuel;
        this.fuelGague = this.logic.fuelGague;
    }

    public void updateProgressBar(int i, int j) {
        if (i == 0) {
            this.logic.progress = j;
        }
        if (i == 1) {
            this.logic.fuel = j;
        }
        if (i == 2) {
            this.logic.fuelGague = j;
        }
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        Block block = this.logic.getWorldObj().getBlock(this.logic.xCoord, this.logic.yCoord, this.logic.zCoord);
        if (block != TinkerTools.heldItemBlock) {
            return false;
        }
        return this.logic.isUseableByPlayer(entityplayer);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotID);
        if (slot != null && slot.getHasStack()) {
            ItemStack slotStack = slot.getStack();
            stack = slotStack.copy();
            if (slotID < this.logic.getSizeInventory() ? !this.mergeItemStack(slotStack, this.logic.getSizeInventory(), this.inventorySlots.size(), true) : !this.mergeItemStack(slotStack, 0, this.logic.getSizeInventory(), false)) {
                return null;
            }
            if (slotStack.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
        }
        return stack;
    }
}

