/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.logic;

import mantle.blocks.abstracts.InventoryLogic;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.modifier.IModifyable;
import tconstruct.tools.inventory.ToolStationContainer;

public class ToolStationLogic
extends InventoryLogic
implements ISidedInventory {
    public ItemStack previousTool;
    public String toolName = "";

    public ToolStationLogic() {
        super(4);
    }

    public ToolStationLogic(int slots) {
        super(slots);
    }

    public boolean canDropInventorySlot(int slot) {
        return slot != 0;
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return null;
    }

    public String getDefaultName() {
        return "crafters.ToolStation";
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new ToolStationContainer(inventoryplayer, this);
    }

    public void markDirty() {
        this.buildTool(this.toolName);
        if (this.worldObj != null) {
            this.blockMetadata = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.markTileEntityChunkModified(this.xCoord, this.yCoord, this.zCoord, (TileEntity)this);
        }
    }

    public void buildTool(String name) {
        ItemStack output = null;
        if (this.inventory[1] != null) {
            if (this.inventory[1].getItem() instanceof IModifyable) {
                output = this.inventory[2] == null && this.inventory[3] == null ? this.inventory[1].copy() : ModifyBuilder.instance.modifyItem(this.inventory[1], new ItemStack[]{this.inventory[2], this.inventory[3]});
            } else {
                NBTTagCompound tags;
                this.toolName = name;
                ItemStack tool = ToolBuilder.instance.buildTool(this.inventory[1], this.inventory[2], this.inventory[3], name);
                if (this.inventory[0] == null) {
                    output = tool;
                } else if (tool != null && !(tags = tool.getTagCompound()).getCompoundTag(((IModifyable)tool.getItem()).getBaseTagName()).hasKey("Built")) {
                    output = tool;
                }
            }
            if (!name.equals("")) {
                output = this.tryRenameTool(output, name);
            }
        }
        this.inventory[0] = output;
    }

    public void setToolname(String name) {
        this.toolName = name;
        this.buildTool(name);
    }

    protected ItemStack tryRenameTool(ItemStack output, String name) {
        ItemStack temp = output != null ? output : this.inventory[1].copy();
        if (temp == null) {
            return null;
        }
        NBTTagCompound tags = temp.getTagCompound();
        if (tags == null) {
            tags = new NBTTagCompound();
            temp.setTagCompound(tags);
        }
        NBTTagCompound display = null;
        if (!tags.hasKey("display")) {
            display = new NBTTagCompound();
        } else if (tags.getCompoundTag("display").hasKey("Name")) {
            display = tags.getCompoundTag("display");
        }
        if (display == null) {
            return output;
        }
        boolean doRename = false;
        if (ToolStationLogic.canRename(display, temp)) {
            doRename = true;
        } else if (!("\u00a7f" + name).equals(display.getString("Name")) && !name.equals(display.getString("Name"))) {
            int nametagCount = 0;
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null || this.inventory[i].getItem() != Items.name_tag) continue;
                ++nametagCount;
            }
            boolean bl = doRename = nametagCount == 1;
        }
        if (!doRename) {
            return output;
        }
        String dName = temp.getItem() instanceof IModifyable ? "\u00a7f" + name : name;
        display.setString("Name", dName);
        tags.setTag("display", (NBTBase)display);
        temp.setRepairCost(2);
        output = temp;
        return output;
    }

    public boolean canUpdate() {
        return false;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return new int[0];
    }

    public boolean canInsertItem(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean canExtractItem(int i, ItemStack itemstack, int j) {
        return false;
    }

    public String getInventoryName() {
        return null;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public static boolean canRename(NBTTagCompound tags, ItemStack tool) {
        return !tags.hasKey("Name") || tags.getString("Name").equals("\u00a7f" + ToolBuilder.defaultToolName(tool));
    }
}

