/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import mantle.common.network.AbstractPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class MovementUpdatePacket
extends AbstractPacket {
    public int entityID;
    public double x;
    public double y;
    public double z;
    public float yaw;
    public float pitch;

    public MovementUpdatePacket() {
    }

    public MovementUpdatePacket(Entity entity) {
        this.entityID = entity.getEntityId();
        this.x = entity.motionX;
        this.y = entity.motionY;
        this.z = entity.motionZ;
        this.yaw = entity.rotationYaw;
        this.pitch = entity.rotationPitch;
    }

    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeFloat(this.yaw);
        buffer.writeFloat(this.pitch);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.yaw = buffer.readFloat();
        this.pitch = buffer.readFloat();
    }

    public void handleClientSide(EntityPlayer player) {
        Entity entity = player.worldObj.getEntityByID(this.entityID);
        if (entity != null) {
            entity.motionX = this.x;
            entity.motionY = this.y;
            entity.motionZ = this.z;
            entity.rotationYaw = this.yaw;
            entity.rotationPitch = this.pitch;
        }
    }

    public void handleServerSide(EntityPlayer player) {
    }
}

