/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry;

import cpw.mods.fml.client.registry.RenderingRegistry;
import mantle.lib.client.MantleClientRegistry;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.client.AmmoItemRenderer;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.tools.TinkerTools;
import tconstruct.util.Reference;
import tconstruct.weaponry.TinkerWeaponry;
import tconstruct.weaponry.WeaponryCommonProxy;
import tconstruct.weaponry.client.AmmoSlotHandler;
import tconstruct.weaponry.client.CrosshairHandler;
import tconstruct.weaponry.client.RenderEventHandler;
import tconstruct.weaponry.client.entity.ArrowEntityRenderer;
import tconstruct.weaponry.client.entity.JavelinEntityRenderer;
import tconstruct.weaponry.client.entity.ProjectileBaseRenderer;
import tconstruct.weaponry.client.entity.ShurikenEntityRenderer;
import tconstruct.weaponry.client.item.BowRenderer;
import tconstruct.weaponry.client.item.CrossbowRenderer;
import tconstruct.weaponry.client.item.JavelinRenderer;
import tconstruct.weaponry.client.item.ThrowingKnifeRenderer;
import tconstruct.weaponry.entity.ArrowEntity;
import tconstruct.weaponry.entity.BoltEntity;
import tconstruct.weaponry.entity.JavelinEntity;
import tconstruct.weaponry.entity.ShurikenEntity;
import tconstruct.weaponry.entity.ThrowingKnifeEntity;

public class WeaponryClientProxy
extends WeaponryCommonProxy {
    public static AmmoItemRenderer renderer;

    @Override
    public void init() {
        super.init();
        MinecraftForge.EVENT_BUS.register((Object)new CrosshairHandler());
        MinecraftForge.EVENT_BUS.register((Object)new AmmoSlotHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
        this.registerRenderers();
        this.registerEntityRendering();
        this.registerMaterialRendering();
        this.buttons();
        this.registerManualIcons();
    }

    private void registerRenderers() {
        renderer = new AmmoItemRenderer();
        MinecraftForgeClient.registerItemRenderer((Item)TinkerWeaponry.shuriken, (IItemRenderer)renderer);
        MinecraftForgeClient.registerItemRenderer((Item)TinkerWeaponry.throwingknife, (IItemRenderer)new ThrowingKnifeRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)TinkerWeaponry.javelin, (IItemRenderer)new JavelinRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)TinkerWeaponry.shortbow, (IItemRenderer)new BowRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)TinkerWeaponry.longbow, (IItemRenderer)new BowRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)TinkerWeaponry.crossbow, (IItemRenderer)new CrossbowRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)TinkerWeaponry.arrowAmmo, (IItemRenderer)renderer);
        MinecraftForgeClient.registerItemRenderer((Item)TinkerWeaponry.boltAmmo, (IItemRenderer)renderer);
    }

    private void registerEntityRendering() {
        ProjectileBaseRenderer defaultRenderer = new ProjectileBaseRenderer();
        RenderingRegistry.registerEntityRenderingHandler(ShurikenEntity.class, (Render)new ShurikenEntityRenderer());
        RenderingRegistry.registerEntityRenderingHandler(ThrowingKnifeEntity.class, defaultRenderer);
        RenderingRegistry.registerEntityRenderingHandler(JavelinEntity.class, (Render)new JavelinEntityRenderer());
        RenderingRegistry.registerEntityRenderingHandler(ArrowEntity.class, (Render)new ArrowEntityRenderer());
        RenderingRegistry.registerEntityRenderingHandler(BoltEntity.class, (Render)new ArrowEntityRenderer(0.8f));
    }

    private void registerMaterialRendering() {
        int i;
        AmmoItem arrow = TinkerWeaponry.arrowAmmo;
        String pre = Reference.resource(arrow.getDefaultFolder()) + "/";
        String[] shaft = new String[]{"wood", "bone", "reed", "blaze", null};
        String[] fletching = new String[]{"feather", "leaf", "slime", "blueslime", "slimeleaf"};
        for (i = 0; i < 5; ++i) {
            String handletex = pre + shaft[i] + arrow.getIconSuffix(2);
            String acctex = pre + fletching[i] + arrow.getIconSuffix(3);
            arrow.registerAlternatePartPaths(i, new String[]{null, null, handletex, acctex});
            TinkerWeaponry.boltAmmo.registerAlternatePartPaths(i, new String[]{null, null, null, acctex});
        }
        pre = Reference.resource(TinkerWeaponry.boltAmmo.getDefaultFolder()) + "/";
        for (i = 0; i < 5; ++i) {
            String acctex = pre + fletching[i] + TinkerWeaponry.boltAmmo.getIconSuffix(3);
            TinkerWeaponry.boltAmmo.registerAlternatePartPaths(i, new String[]{null, null, null, acctex});
        }
        String[] bowstringTypes = new String[]{"string", "magicfabric", "flamestring"};
        for (int bowIter = 0; bowIter < bowstringTypes.length; ++bowIter) {
            TConstructClientRegistry.addAlternateMaterialRenderMapping(TinkerWeaponry.shortbow, bowIter, "tinker", bowstringTypes[bowIter], true);
        }
    }

    private void buttons() {
        String locString;
        int i;
        String tex = "textures/gui/icons.png";
        TConstructClientRegistry.addStencilButton2(11, 3, 21, "tinker", "textures/gui/icons.png");
        TConstructClientRegistry.addStencilButton2(12, 3, 22, "tinker", "textures/gui/icons.png");
        TConstructClientRegistry.addStencilButton2(0, 0, -1, null, null);
        TConstructClientRegistry.addStencilButton2(0, 0, -1, null, null);
        TConstructClientRegistry.addStencilButton2(3, 4, 27, "tinker", "textures/gui/icons.png");
        TConstructClientRegistry.addStencilButton2(10, 3, 23, "tinker", "textures/gui/icons.png");
        TConstructClientRegistry.addStencilButton2(1, 4, 25, "tinker", "textures/gui/icons.png");
        TConstructClientRegistry.addStencilButton2(2, 4, 26, "tinker", "textures/gui/icons.png");
        TConstructClientRegistry.addStencilButton2(0, 4, 24, "tinker", "textures/gui/icons.png");
        ToolCore[] tools = new ToolCore[]{TinkerWeaponry.shortbow, TinkerWeaponry.arrowAmmo, TinkerWeaponry.throwingknife, TinkerWeaponry.javelin};
        int[][] icons = new int[][]{{3, 9, 1}, {7, 10, 1}, {2, 1, 5}, {1, 2, 5}};
        int[][] coords = new int[][]{{3, 10, 3, 13}, {4, 3, 4, 13}, {11, 0, 12, 13}, {3, 3, 3, 13}, {7, 0, 13, 13}, {2, 3, 13, 13}, {11, 8, 8, 13}, {3, 3, 3, 13}};
        for (i = 0; i < tools.length; ++i) {
            locString = String.format("gui.toolstation.%s.desc", tools[i].getToolName().toLowerCase());
            TConstructClientRegistry.addToolButton(icons[i][0], icons[i][1], icons[i][2], coords[i * 2], coords[i * 2 + 1], tools[i].getLocalizedToolName(), locString, "tinker", "textures/gui/icons.png");
        }
        tools = new ToolCore[]{TinkerWeaponry.longbow, TinkerWeaponry.crossbow, TinkerWeaponry.boltAmmo, TinkerWeaponry.shuriken};
        icons = new int[][]{{8, 11, 1}, {9, 12, 1}, {2, 13, 1}, {4, 0, 5}};
        coords = new int[][]{{3, 10, 3, 9}, {4, 3, 4, 2}, {1, 2, 10, 9}, {4, 4, 3, 3}, {4, 12, 13, 13}, {4, 3, 13, 13}, {0, 0, 0, 0}, {4, 4, 4, 4}};
        for (i = 0; i < tools.length; ++i) {
            locString = String.format("gui.toolstation.%s.desc", tools[i].getToolName().toLowerCase());
            TConstructClientRegistry.addTierTwoButton(icons[i][0], icons[i][1], icons[i][2], coords[i * 2], coords[i * 2 + 1], tools[i].getLocalizedToolName(), locString, "tinker", "textures/gui/icons.png");
        }
    }

    public void registerManualIcons() {
        MantleClientRegistry.registerManualIcon((String)"throwingknifeIcon", (ItemStack)ToolBuilder.instance.buildTool(new ItemStack(TinkerTools.knifeBlade, 1, 2), new ItemStack(TinkerTools.toolRod, 1, 11), null, ""));
        MantleClientRegistry.registerManualIcon((String)"shortbowIcon", (ItemStack)ToolBuilder.instance.buildTool(new ItemStack((Item)TinkerWeaponry.partBowLimb, 1, 0), new ItemStack(TinkerWeaponry.bowstring, 1, 0), new ItemStack((Item)TinkerWeaponry.partBowLimb, 1, 0), ""));
        MantleClientRegistry.registerManualIcon((String)"arrowIcon", (ItemStack)ToolBuilder.instance.buildTool(new ItemStack((Item)TinkerWeaponry.arrowhead, 1, 3), new ItemStack(Items.stick), new ItemStack(TinkerWeaponry.fletching, 1, 0), ""));
        MantleClientRegistry.registerManualIcon((String)"weaponrybook", (ItemStack)new ItemStack(TinkerTools.manualBook, 1, 4));
    }
}

