/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.weapons;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.weaponry.AmmoWeapon;
import tconstruct.tools.TinkerTools;
import tconstruct.weaponry.TinkerWeaponry;
import tconstruct.weaponry.client.CrosshairType;
import tconstruct.weaponry.entity.JavelinEntity;

public class Javelin
extends AmmoWeapon {
    public Javelin() {
        super(3, "Javelin");
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return AbilityHelper.onLeftClickEntity(stack, (EntityLivingBase)player, entity, this, 0);
    }

    @Override
    public float getWindupProgress(ItemStack itemStack, EntityPlayer player) {
        float threshold;
        if (!itemStack.hasTagCompound()) {
            return super.getWindupProgress(itemStack, player);
        }
        if (!itemStack.getTagCompound().getCompoundTag("InfiTool").hasKey("Throwing")) {
            return 0.5f;
        }
        float timeleft = itemStack.getTagCompound().getCompoundTag("InfiTool").getInteger("Throwing");
        if (timeleft < (threshold = (float)(this.getWindupTime(itemStack) / 5))) {
            return (threshold - timeleft) / threshold;
        }
        return 0.5f - 0.25f * ((float)this.getWindupTime(itemStack) - timeleft) / threshold;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        if (tags.hasKey("Throwing")) {
            return stack;
        }
        if (this.getAmmoCount(stack) <= 0) {
            return stack;
        }
        tags.setInteger("Throwing", this.getWindupTime(stack));
        return stack;
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        super.onUpdate(stack, world, entity, par4, par5);
        if (!stack.hasTagCompound()) {
            return;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        if (!tags.hasKey("Throwing")) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.inventory.getCurrentItem() != stack) {
            return;
        }
        int timeLeft = tags.getInteger("Throwing");
        if (--timeLeft > 0) {
            tags.setInteger("Throwing", timeLeft);
        } else {
            this.onPlayerStoppedUsing(stack, world, player, 0);
            tags.removeTag("Throwing");
        }
    }

    @Override
    public boolean zoomOnWindup(ItemStack itemStack) {
        return true;
    }

    @Override
    public float getZoom(ItemStack itemStack) {
        return 1.5f;
    }

    @Override
    public float minAccuracy(ItemStack itemStack) {
        return 2.5f;
    }

    @Override
    public float maxAccuracy(ItemStack itemStack) {
        return 0.5f;
    }

    @Override
    public int getWindupTime(ItemStack itemStack) {
        return 17;
    }

    @Override
    public int getPartAmount() {
        return 3;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_javelin_head";
            }
            case 1: {
                return "_javelin_head_broken";
            }
            case 2: {
                return "_javelin_handle";
            }
            case 3: {
                return "_javelin_accessory";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_javelin_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "javelin";
    }

    @Override
    public float getAmmoModifier() {
        return 0.2f;
    }

    @Override
    public float getDurabilityModifier() {
        return 0.1f;
    }

    @Override
    public Item getHeadItem() {
        return TinkerWeaponry.arrowhead;
    }

    @Override
    public Item getHandleItem() {
        return TinkerTools.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerTools.toughRod;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"weapon", "thrown", "ammo", "windup"};
    }

    @Override
    protected Entity createProjectile(ItemStack reference, World world, EntityPlayer player, float accuracy, int time) {
        reference.getTagCompound().getCompoundTag("InfiTool").removeTag("Throwing");
        JavelinEntity entity = new JavelinEntity(world, player, this.getProjectileSpeed(), accuracy, reference);
        return entity;
    }

    @Override
    public float getProjectileSpeed() {
        return 2.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CrosshairType getCrosshairType() {
        return CrosshairType.WEIRD;
    }
}

