/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class MiningExplosion
extends Explosion {
    World world;
    private Random random = new Random();
    private int field_77289_h = 16;
    private Map field_77288_k = new HashMap();

    public MiningExplosion(World par1World, Entity par2Entity, double par3, double par5, double par7, float par9) {
        super(par1World, par2Entity, par3, par5, par7, par9);
        this.world = par1World;
    }

    public void doExplosionA() {
        double d2;
        double d1;
        double d0;
        int k;
        int j;
        int i;
        float f = this.explosionSize;
        HashSet<ChunkPosition> hashset = new HashSet<ChunkPosition>();
        for (i = 0; i < this.field_77289_h; ++i) {
            for (j = 0; j < this.field_77289_h; ++j) {
                for (k = 0; k < this.field_77289_h; ++k) {
                    if (i != 0 && i != this.field_77289_h - 1 && j != 0 && j != this.field_77289_h - 1 && k != 0 && k != this.field_77289_h - 1) continue;
                    double d3 = (float)i / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d4 = (float)j / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d5 = (float)k / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    d0 = this.explosionX;
                    d1 = this.explosionY;
                    d2 = this.explosionZ;
                    float f2 = 0.3f;
                    for (float f1 = this.explosionSize * (0.7f + this.world.rand.nextFloat() * 0.6f); f1 > 0.0f; f1 -= f2 * 0.75f) {
                        int j1;
                        int i1;
                        int l = MathHelper.floor_double((double)d0);
                        Block k1 = this.world.getBlock(l, i1 = MathHelper.floor_double((double)d1), j1 = MathHelper.floor_double((double)d2));
                        if (k1 != Blocks.air) {
                            Block block = k1;
                            float f3 = this.exploder != null ? this.exploder.func_145772_a((Explosion)this, this.world, l, i1, j1, block) : block.getExplosionResistance(this.exploder, this.world, l, i1, j1, this.explosionX, this.explosionY, this.explosionZ);
                            f1 -= (f3 + 0.8f) * f2 * 0.25f;
                        }
                        if (f1 > 0.0f && (this.exploder == null || this.exploder.func_145774_a((Explosion)this, this.world, l, i1, j1, k1, f1))) {
                            hashset.add(new ChunkPosition(l, i1, j1));
                        }
                        d0 += d3 * (double)f2;
                        d1 += d4 * (double)f2;
                        d2 += d5 * (double)f2;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(hashset);
        this.explosionSize *= 2.0f;
        i = MathHelper.floor_double((double)(this.explosionX - (double)this.explosionSize - 1.0));
        j = MathHelper.floor_double((double)(this.explosionX + (double)this.explosionSize + 1.0));
        k = MathHelper.floor_double((double)(this.explosionY - (double)this.explosionSize - 1.0));
        int l1 = MathHelper.floor_double((double)(this.explosionY + (double)this.explosionSize + 1.0));
        int i2 = MathHelper.floor_double((double)(this.explosionZ - (double)this.explosionSize - 1.0));
        int j2 = MathHelper.floor_double((double)(this.explosionZ + (double)this.explosionSize + 1.0));
        List list = this.world.getEntitiesWithinAABBExcludingEntity(this.exploder, AxisAlignedBB.getBoundingBox((double)i, (double)k, (double)i2, (double)j, (double)l1, (double)j2));
        Vec3 vec3 = Vec3.createVectorHelper((double)this.explosionX, (double)this.explosionY, (double)this.explosionZ);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            double d8;
            Entity entity = (Entity)list.get(k2);
            double d7 = entity.getDistance(this.explosionX, this.explosionY, this.explosionZ) / (double)this.explosionSize;
            if (!(d7 <= 1.0) || (d8 = (double)MathHelper.sqrt_double((double)((d0 = entity.posX - this.explosionX) * d0 + (d1 = entity.posY + (double)entity.getEyeHeight() - this.explosionY) * d1 + (d2 = entity.posZ - this.explosionZ) * d2))) == 0.0) continue;
            d0 /= d8;
            d1 /= d8;
            d2 /= d8;
            double d9 = this.world.getBlockDensity(vec3, entity.boundingBox);
            double d10 = (1.0 - d7) * d9;
            if (!(entity instanceof EntityItem)) {
                entity.attackEntityFrom(DamageSource.setExplosionSource((Explosion)this), (float)((int)((d10 * d10 + d10) / 2.0 * 8.0 * (double)this.explosionSize + 1.0)));
            }
            double d11 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d10);
            entity.motionX += d0 * d11;
            entity.motionY += d1 * d11;
            entity.motionZ += d2 * d11;
            if (!(entity instanceof EntityPlayer)) continue;
            this.field_77288_k.put((EntityPlayer)entity, Vec3.createVectorHelper((double)(d0 * d10), (double)(d1 * d10), (double)(d2 * d10)));
        }
        this.explosionSize = f;
    }

    public void doExplosionB(boolean par1) {
        Block l;
        int k;
        int j;
        int i;
        this.world.playSoundEffect(this.explosionX, this.explosionY, this.explosionZ, "random.explode", 4.0f, (1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f) * 0.7f);
        if (this.explosionSize >= 2.0f && this.isSmoking) {
            this.world.spawnParticle("hugeexplosion", this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0);
        } else {
            this.world.spawnParticle("largeexplode", this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0);
        }
        if (this.isSmoking) {
            for (ChunkPosition chunkposition : this.affectedBlockPositions) {
                i = chunkposition.chunkPosX;
                j = chunkposition.chunkPosY;
                k = chunkposition.chunkPosZ;
                l = this.world.getBlock(i, j, k);
                if (par1) {
                    double d0 = (float)i + this.world.rand.nextFloat();
                    double d1 = (float)j + this.world.rand.nextFloat();
                    double d2 = (float)k + this.world.rand.nextFloat();
                    double d3 = d0 - this.explosionX;
                    double d4 = d1 - this.explosionY;
                    double d5 = d2 - this.explosionZ;
                    double d6 = MathHelper.sqrt_double((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
                    this.world.spawnParticle("explode", (d0 + this.explosionX * 1.0) / 2.0, (d1 + this.explosionY * 1.0) / 2.0, (d2 + this.explosionZ * 1.0) / 2.0, d3 *= (d7 *= (double)(this.world.rand.nextFloat() * this.world.rand.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                    this.world.spawnParticle("smoke", d0, d1, d2, d3, d4, d5);
                }
                if (l == Blocks.air) continue;
                Block block = l;
                if (block.canDropFromExplosion((Explosion)this)) {
                    block.dropBlockAsItemWithChance(this.world, i, j, k, this.world.getBlockMetadata(i, j, k), 1.0f, 0);
                }
                block.onBlockExploded(this.world, i, j, k, (Explosion)this);
            }
        }
        if (this.isFlaming) {
            for (ChunkPosition chunkposition : this.affectedBlockPositions) {
                i = chunkposition.chunkPosX;
                j = chunkposition.chunkPosY;
                k = chunkposition.chunkPosZ;
                l = this.world.getBlock(i, j, k);
                Block i1 = this.world.getBlock(i, j - 1, k);
                if (l != Blocks.air || !i1.isOpaqueCube() || this.random.nextInt(3) != 0) continue;
                this.world.setBlock(i, j, k, (Block)Blocks.fire);
            }
        }
    }
}

