/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.world.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import tconstruct.blocks.TConstructBlock;
import tconstruct.mechworks.entity.item.ExplosivePrimed;

public class SlimeExplosive
extends TConstructBlock {
    public SlimeExplosive() {
        super(Material.tnt, 0.0f, SlimeExplosive.getTextureNames());
    }

    static String[] getTextureNames() {
        String[] names = new String[6];
        String[] types = new String[]{"green", "blue"};
        for (int i = 0; i < 2; ++i) {
            names[i * 3 + 0] = "sdx_bottom_" + types[i];
            names[i * 3 + 1] = "sdx_side_" + types[i];
            names[i * 3 + 2] = "sdx_top_" + types[i];
        }
        return names;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.icons[meta / 2 * 3 + this.getSideTextureIndex(side)];
    }

    @Override
    public void getSubBlocks(Item b, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 2; ++iter) {
            list.add(new ItemStack(b, 1, iter * 2));
        }
    }

    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        super.onBlockAdded(par1World, par2, par3, par4);
        if (par1World.isBlockIndirectlyGettingPowered(par2, par3, par4)) {
            this.onBlockDestroyedByPlayer(par1World, par2, par3, par4, 1);
            WorldHelper.setBlockToAir((World)par1World, (int)par2, (int)par3, (int)par4);
        }
    }

    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, Block par5Block) {
        if (par1World.isBlockIndirectlyGettingPowered(par2, par3, par4)) {
            this.onBlockDestroyedByPlayer(par1World, par2, par3, par4, 1);
            WorldHelper.setBlockToAir((World)par1World, (int)par2, (int)par3, (int)par4);
        }
    }

    public void onBlockDestroyedByExplosion(World par1World, int par2, int par3, int par4, Explosion par5Explosion) {
        if (!par1World.isRemote) {
            ExplosivePrimed entitytntprimed = new ExplosivePrimed(par1World, (float)par2 + 0.5f, (float)par3 + 0.5f, (float)par4 + 0.5f, par5Explosion.getExplosivePlacedBy());
            entitytntprimed.fuse = par1World.rand.nextInt(entitytntprimed.fuse / 4) + entitytntprimed.fuse / 8;
            par1World.spawnEntityInWorld((Entity)entitytntprimed);
        }
    }

    public void onBlockDestroyedByPlayer(World par1World, int par2, int par3, int par4, int par5) {
        this.primeTnt(par1World, par2, par3, par4, par5, null);
    }

    public void primeTnt(World par1World, int par2, int par3, int par4, int par5, EntityLivingBase par6EntityLivingBase) {
        if (!par1World.isRemote && par5 % 2 == 1) {
            ExplosivePrimed entitytntprimed = new ExplosivePrimed(par1World, (float)par2 + 0.5f, (float)par3 + 0.5f, (float)par4 + 0.5f, par6EntityLivingBase);
            par1World.spawnEntityInWorld((Entity)entitytntprimed);
            par1World.playSoundAtEntity((Entity)entitytntprimed, "random.fuse", 1.0f, 1.0f);
        }
    }

    public boolean onBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (par5EntityPlayer.getCurrentEquippedItem() != null && par5EntityPlayer.getCurrentEquippedItem().getItem() == Items.flint_and_steel) {
            this.primeTnt(par1World, par2, par3, par4, 1, (EntityLivingBase)par5EntityPlayer);
            WorldHelper.setBlockToAir((World)par1World, (int)par2, (int)par3, (int)par4);
            par5EntityPlayer.getCurrentEquippedItem().damageItem(1, (EntityLivingBase)par5EntityPlayer);
            return true;
        }
        return super.onBlockActivated(par1World, par2, par3, par4, par5EntityPlayer, par6, par7, par8, par9);
    }

    public void onEntityCollidedWithBlock(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        EntityArrow entityarrow;
        if (par5Entity instanceof EntityArrow && !par1World.isRemote && (entityarrow = (EntityArrow)par5Entity).isBurning()) {
            this.primeTnt(par1World, par2, par3, par4, 1, entityarrow.shootingEntity instanceof EntityLivingBase ? (EntityLivingBase)entityarrow.shootingEntity : null);
            WorldHelper.setBlockToAir((World)par1World, (int)par2, (int)par3, (int)par4);
        }
    }

    public boolean canDropFromExplosion(Explosion par1Explosion) {
        return false;
    }
}

