/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CartEntity
extends Entity
implements IInventory,
IEntityAdditionalSpawnData {
    protected ItemStack[] cargoItems = new ItemStack[36];
    protected int fuel = 0;
    protected boolean isInReverse = false;
    private int pullcartType;
    public double pushX;
    public double pushZ;
    protected boolean field_82345_h = true;
    protected static final int[][][] matrix = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    protected int turnProgress;
    protected double minecartX;
    protected double minecartY;
    protected double minecartZ;
    protected double minecartYaw;
    protected double minecartPitch;
    @SideOnly(value=Side.CLIENT)
    protected double velocityX;
    @SideOnly(value=Side.CLIENT)
    protected double velocityY;
    @SideOnly(value=Side.CLIENT)
    protected double velocityZ;
    public static float defaultMaxSpeedRail = 0.4f;
    public static float defaultMaxSpeedGround = 0.4f;
    public static float defaultMaxSpeedAirLateral = 0.4f;
    public static float defaultMaxSpeedAirVertical = -1.0f;
    public static double defaultDragRidden = 0.997f;
    public static double defaultDragEmpty = 0.96f;
    public static double defaultDragAir = 0.95f;
    protected boolean canUseRail = true;
    protected boolean canBePushed = true;
    protected float maxSpeedRail;
    protected float maxSpeedGround;
    protected float maxSpeedAirLateral;
    protected float maxSpeedAirVertical;
    protected double dragAir;
    Entity entityFollowing;

    public CartEntity(World par1World) {
        super(par1World);
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.7f);
        this.yOffset = this.height / 2.0f;
        this.stepHeight = 1.0f;
        this.maxSpeedRail = defaultMaxSpeedRail;
        this.maxSpeedGround = defaultMaxSpeedGround;
        this.maxSpeedAirLateral = defaultMaxSpeedAirLateral;
        this.maxSpeedAirVertical = defaultMaxSpeedAirVertical;
        this.dragAir = defaultDragAir;
    }

    public CartEntity(World world, int type) {
        this(world);
        this.pullcartType = type;
    }

    public CartEntity(World world, double x, double y, double z, int type) {
        this(world);
        this.setPosition(x, y + (double)this.yOffset, z);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
        this.pullcartType = type;
        this.stepHeight = 1.0f;
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected void entityInit() {
        this.dataWatcher.addObject(16, (Object)new Byte(0));
        this.dataWatcher.addObject(17, (Object)new Integer(0));
        this.dataWatcher.addObject(18, (Object)new Integer(1));
        this.dataWatcher.addObject(19, (Object)new Integer(0));
    }

    public AxisAlignedBB getCollisionBox(Entity par1Entity) {
        return par1Entity.boundingBox;
    }

    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    public boolean canBePushed() {
        return this.canBePushed;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.0 - (double)0.3f;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        if (!this.worldObj.isRemote && !this.isDead) {
            if (this.isEntityInvulnerable()) {
                return false;
            }
            this.setRollingDirection(-this.getRollingDirection());
            this.setRollingAmplitude(10);
            this.setBeenAttacked();
            this.setDamage(this.getDamage() + par2 * 10);
            if (par1DamageSource.getEntity() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.getEntity()).capabilities.isCreativeMode) {
                this.setDamage(100);
            }
            if (this.getDamage() > 40) {
                if (this.riddenByEntity != null) {
                    this.riddenByEntity.mountEntity((Entity)this);
                }
                this.setDead();
                this.dropCartAsItem();
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void performHurtAnimation() {
        this.setRollingDirection(-this.getRollingDirection());
        this.setRollingAmplitude(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10);
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    public void setDead() {
        if (this.field_82345_h) {
            for (int var1 = 0; var1 < this.getSizeInventory(); ++var1) {
                ItemStack var2 = this.getStackInSlot(var1);
                if (var2 == null) continue;
                float var3 = this.rand.nextFloat() * 0.8f + 0.1f;
                float var4 = this.rand.nextFloat() * 0.8f + 0.1f;
                float var5 = this.rand.nextFloat() * 0.8f + 0.1f;
                while (var2.stackSize > 0) {
                    int var6 = this.rand.nextInt(21) + 10;
                    if (var6 > var2.stackSize) {
                        var6 = var2.stackSize;
                    }
                    var2.stackSize -= var6;
                    EntityItem entityitem = new EntityItem(this.worldObj, this.posX + (double)var3, this.posY + (double)var4, this.posZ + (double)var5, new ItemStack(var2.getItem(), var6, var2.getItemDamage()));
                    if (var2.hasTagCompound()) {
                        entityitem.getEntityItem().setTagCompound((NBTTagCompound)var2.getTagCompound().copy());
                    }
                    float var8 = 0.05f;
                    entityitem.motionX = (float)this.rand.nextGaussian() * var8;
                    entityitem.motionY = (float)this.rand.nextGaussian() * var8 + 0.2f;
                    entityitem.motionZ = (float)this.rand.nextGaussian() * var8;
                    this.worldObj.spawnEntityInWorld((Entity)entityitem);
                }
            }
        }
        super.setDead();
    }

    public void travelToDimension(int par1) {
        this.field_82345_h = false;
        super.travelToDimension(par1);
    }

    public void onUpdate() {
        int var2;
        if (this.getRollingAmplitude() > 0) {
            this.setRollingAmplitude(this.getRollingAmplitude() - 1);
        }
        if (this.getDamage() > 0) {
            this.setDamage(this.getDamage() - 1);
        }
        if (this.posY < -64.0) {
            this.kill();
        }
        if (this.isMinecartPowered() && this.rand.nextInt(4) == 0 && this.pullcartType == 2 && ((Object)((Object)this)).getClass() == CartEntity.class) {
            this.worldObj.spawnParticle("largesmoke", this.posX, this.posY + 0.8, this.posZ, 0.0, 0.0, 0.0);
        }
        if (!this.worldObj.isRemote && this.worldObj instanceof WorldServer) {
            this.worldObj.theProfiler.startSection("portal");
            MinecraftServer var1 = ((WorldServer)this.worldObj).func_73046_m();
            var2 = this.getMaxInPortalTime();
            if (!this.inPortal || var1.getAllowNether()) {
                // empty if block
            }
            if (this.timeUntilPortal > 0) {
                --this.timeUntilPortal;
            }
            this.worldObj.theProfiler.endSection();
        }
        if (this.worldObj.isRemote) {
            if (this.turnProgress > 0) {
                double var46 = this.posX + (this.minecartX - this.posX) / (double)this.turnProgress;
                double var48 = this.posY + (this.minecartY - this.posY) / (double)this.turnProgress;
                double var5 = this.posZ + (this.minecartZ - this.posZ) / (double)this.turnProgress;
                double var7 = MathHelper.wrapAngleTo180_double((double)(this.minecartYaw - (double)this.rotationYaw));
                this.rotationYaw = (float)((double)this.rotationYaw + var7 / (double)this.turnProgress);
                this.rotationPitch = (float)((double)this.rotationPitch + (this.minecartPitch - (double)this.rotationPitch) / (double)this.turnProgress);
                --this.turnProgress;
                this.setPosition(var46, var48, var5);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            } else {
                this.setPosition(this.posX, this.posY, this.posZ);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            }
        } else {
            double var51;
            int var47;
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            this.motionY -= (double)0.04f;
            int var45 = MathHelper.floor_double((double)this.posX);
            if (BlockRail.func_150049_b_((World)this.worldObj, (int)var45, (int)((var2 = MathHelper.floor_double((double)this.posY)) - 1), (int)(var47 = MathHelper.floor_double((double)this.posZ)))) {
                --var2;
            }
            double var4 = 0.4;
            double var6 = 0.0078125;
            Block var8 = this.worldObj.getBlock(var45, var2, var47);
            this.moveMinecartOffRail(var45, var2, var47);
            if (this.entityFollowing != null) {
                this.moveTowardsEntity(this.entityFollowing);
            }
            this.func_145775_I();
            this.rotationPitch = 0.0f;
            double var49 = this.prevPosX - this.posX;
            double var50 = this.prevPosZ - this.posZ;
            if (var49 * var49 + var50 * var50 > 0.001) {
                this.rotationYaw = (float)(Math.atan2(var50, var49) * 180.0 / Math.PI);
                if (this.isInReverse) {
                    this.rotationYaw += 180.0f;
                }
            }
            if ((var51 = (double)MathHelper.wrapAngleTo180_float((float)(this.rotationYaw - this.prevRotationYaw))) < -170.0 || var51 >= 170.0) {
                this.rotationYaw += 180.0f;
                this.isInReverse = !this.isInReverse;
            }
            this.setRotation(this.rotationYaw, this.rotationPitch);
            AxisAlignedBB box = this.boundingBox.expand(0.2, 0.0, 0.2);
            List var15 = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, box);
            if (var15 != null && !var15.isEmpty()) {
                for (int var52 = 0; var52 < var15.size(); ++var52) {
                    Entity var17 = (Entity)var15.get(var52);
                    if (var17 == this.riddenByEntity || !var17.canBePushed() || !(var17 instanceof CartEntity)) continue;
                    var17.applyEntityCollision((Entity)this);
                }
            }
            if (this.riddenByEntity != null && this.riddenByEntity.isDead) {
                if (this.riddenByEntity.ridingEntity == this) {
                    this.riddenByEntity.ridingEntity = null;
                }
                this.riddenByEntity = null;
            }
            this.updateFuel();
        }
    }

    void moveTowardsEntity(Entity entity) {
        double var15 = entity.posX;
        double var19 = entity.posZ;
        if (this.calculateDistance(this.prevPosX, var15) > 1.5 || this.calculateDistance(this.prevPosZ, var19) > 1.5) {
            double var28 = this.prevPosX;
            double var30 = this.prevPosZ;
            double var36 = this.calculateDistance(var28, var15);
            double var38 = this.calculateDistance(var30, var19);
            double var40 = 1.0;
            double var42 = 1.0;
            if (var36 > var38) {
                double var46 = 1.0;
                double var44 = var38 / var36;
                var42 = var44 / 3.0;
                var40 = var46 / 3.0;
            } else if (var38 > var36) {
                double var44 = 1.0;
                double var46 = var36 / var38;
                var40 = var46 / 3.0;
                var42 = var44 / 3.0;
            }
            this.motionX = var15 > var28 ? var40 : -var40;
            this.motionZ = var19 > var30 ? var42 : -var42;
        }
    }

    public double calculateDistance(double pos1, double pos2) {
        double distance = Math.abs(pos1 - pos2);
        return distance;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_70495_a(double par1, double par3, double par5, double par7) {
        int var11;
        int var10;
        int var9 = MathHelper.floor_double((double)par1);
        if (BlockRail.func_150049_b_((World)this.worldObj, (int)var9, (int)((var10 = MathHelper.floor_double((double)par3)) - 1), (int)(var11 = MathHelper.floor_double((double)par5)))) {
            --var10;
        }
        Block var12 = this.worldObj.getBlock(var9, var10, var11);
        return null;
    }

    public Vec3 func_70489_a(double par1, double par3, double par5) {
        Block var10;
        int var9;
        int var8;
        int var7 = MathHelper.floor_double((double)par1);
        if (BlockRail.func_150049_b_((World)this.worldObj, (int)var7, (int)((var8 = MathHelper.floor_double((double)par3)) - 1), (int)(var9 = MathHelper.floor_double((double)par5)))) {
            --var8;
        }
        if (BlockRail.func_150051_a((Block)(var10 = this.worldObj.getBlock(var7, var8, var9)))) {
            int var11 = 0;
            par3 = var8;
            if (var11 >= 2 && var11 <= 5) {
                par3 = var8 + 1;
            }
            int[][] var12 = matrix[var11];
            double var13 = 0.0;
            double var15 = (double)var7 + 0.5 + (double)var12[0][0] * 0.5;
            double var17 = (double)var8 + 0.5 + (double)var12[0][1] * 0.5;
            double var19 = (double)var9 + 0.5 + (double)var12[0][2] * 0.5;
            double var21 = (double)var7 + 0.5 + (double)var12[1][0] * 0.5;
            double var23 = (double)var8 + 0.5 + (double)var12[1][1] * 0.5;
            double var25 = (double)var9 + 0.5 + (double)var12[1][2] * 0.5;
            double var27 = var21 - var15;
            double var29 = (var23 - var17) * 2.0;
            double var31 = var25 - var19;
            if (var27 == 0.0) {
                par1 = (double)var7 + 0.5;
                var13 = par5 - (double)var9;
            } else if (var31 == 0.0) {
                par5 = (double)var9 + 0.5;
                var13 = par1 - (double)var7;
            } else {
                double var33 = par1 - var15;
                double var35 = par5 - var19;
                var13 = (var33 * var27 + var35 * var31) * 2.0;
            }
            par1 = var15 + var27 * var13;
            par3 = var17 + var29 * var13;
            par5 = var19 + var31 * var13;
            if (var29 < 0.0) {
                par3 += 1.0;
            }
            if (var29 > 0.0) {
                par3 += 0.5;
            }
            return Vec3.createVectorHelper((double)par1, (double)par3, (double)par5);
        }
        return null;
    }

    protected void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setInteger("Type", this.pullcartType);
        if (this.isPoweredCart()) {
            par1NBTTagCompound.setDouble("PushX", this.pushX);
            par1NBTTagCompound.setDouble("PushZ", this.pushZ);
            par1NBTTagCompound.setInteger("Fuel", this.fuel);
        }
        if (this.getSizeInventory() > 0) {
            NBTTagList var2 = new NBTTagList();
            for (int var3 = 0; var3 < this.cargoItems.length; ++var3) {
                if (this.cargoItems[var3] == null) continue;
                NBTTagCompound var4 = new NBTTagCompound();
                var4.setByte("Slot", (byte)var3);
                this.cargoItems[var3].writeToNBT(var4);
                var2.appendTag((NBTBase)var4);
            }
            par1NBTTagCompound.setTag("Items", (NBTBase)var2);
        }
    }

    protected void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.pullcartType = par1NBTTagCompound.getInteger("Type");
        if (this.isPoweredCart()) {
            this.pushX = par1NBTTagCompound.getDouble("PushX");
            this.pushZ = par1NBTTagCompound.getDouble("PushZ");
            try {
                this.fuel = par1NBTTagCompound.getInteger("Fuel");
            }
            catch (ClassCastException e) {
                this.fuel = par1NBTTagCompound.getShort("Fuel");
            }
        }
        if (this.getSizeInventory() > 0) {
            NBTTagList var2 = par1NBTTagCompound.getTagList("Items", 10);
            this.cargoItems = new ItemStack[this.getSizeInventory()];
            for (int var3 = 0; var3 < var2.tagCount(); ++var3) {
                NBTTagCompound var4 = var2.getCompoundTagAt(var3);
                int var5 = var4.getByte("Slot") & 0xFF;
                if (var5 < 0 || var5 >= this.cargoItems.length) continue;
                this.cargoItems[var5] = ItemStack.loadItemStackFromNBT((NBTTagCompound)var4);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.5f;
    }

    public void applyEntityCollision(Entity par1Entity) {
        if (!this.worldObj.isRemote && par1Entity != this.riddenByEntity) {
            double var4;
            double var2;
            double var6;
            if (par1Entity instanceof EntityLiving && !(par1Entity instanceof EntityPlayer) && !(par1Entity instanceof EntityIronGolem) && this.canBeRidden() && this.motionX * this.motionX + this.motionZ * this.motionZ > 0.01 && this.riddenByEntity == null && par1Entity.ridingEntity == null) {
                par1Entity.mountEntity((Entity)this);
            }
            if ((var6 = (var2 = par1Entity.posX - this.posX) * var2 + (var4 = par1Entity.posZ - this.posZ) * var4) >= (double)1.0E-4f) {
                var6 = MathHelper.sqrt_double((double)var6);
                var2 /= var6;
                var4 /= var6;
                double var8 = 1.0 / var6;
                if (var8 > 1.0) {
                    var8 = 1.0;
                }
                var2 *= var8;
                var4 *= var8;
                var2 *= (double)0.1f;
                var4 *= (double)0.1f;
                var2 *= (double)(1.0f - this.entityCollisionReduction);
                var4 *= (double)(1.0f - this.entityCollisionReduction);
                var2 *= 0.5;
                var4 *= 0.5;
                if (par1Entity instanceof CartEntity) {
                    Vec3 var15;
                    double var10 = par1Entity.posX - this.posX;
                    double var12 = par1Entity.posZ - this.posZ;
                    Vec3 var14 = Vec3.createVectorHelper((double)var10, (double)0.0, (double)var12).normalize();
                    double var16 = Math.abs(var14.dotProduct(var15 = Vec3.createVectorHelper((double)MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)), (double)0.0, (double)MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f))).normalize()));
                    if (var16 < 0.8) {
                        return;
                    }
                    double var18 = par1Entity.motionX + this.motionX;
                    double var20 = par1Entity.motionZ + this.motionZ;
                    if (((CartEntity)par1Entity).isPoweredCart() && !this.isPoweredCart()) {
                        this.motionX *= (double)0.2f;
                        this.motionZ *= (double)0.2f;
                        this.addVelocity(par1Entity.motionX - var2, 0.0, par1Entity.motionZ - var4);
                        par1Entity.motionX *= (double)0.95f;
                        par1Entity.motionZ *= (double)0.95f;
                    } else if (!((CartEntity)par1Entity).isPoweredCart() && this.isPoweredCart()) {
                        par1Entity.motionX *= (double)0.2f;
                        par1Entity.motionZ *= (double)0.2f;
                        par1Entity.addVelocity(this.motionX + var2, 0.0, this.motionZ + var4);
                        this.motionX *= (double)0.95f;
                        this.motionZ *= (double)0.95f;
                    } else {
                        this.motionX *= (double)0.2f;
                        this.motionZ *= (double)0.2f;
                        this.addVelocity((var18 /= 2.0) - var2, 0.0, (var20 /= 2.0) - var4);
                        par1Entity.motionX *= (double)0.2f;
                        par1Entity.motionZ *= (double)0.2f;
                        par1Entity.addVelocity(var18 + var2, 0.0, var20 + var4);
                    }
                } else {
                    this.addVelocity(-var2, 0.0, -var4);
                    par1Entity.addVelocity(var2 / 4.0, 0.0, var4 / 4.0);
                }
            }
        }
    }

    public int getSizeInventory() {
        return this.pullcartType == 1 && ((Object)((Object)this)).getClass() == CartEntity.class ? 27 : 0;
    }

    public ItemStack getStackInSlot(int par1) {
        return this.cargoItems[par1];
    }

    public ItemStack decrStackSize(int par1, int par2) {
        if (this.cargoItems[par1] != null) {
            if (this.cargoItems[par1].stackSize <= par2) {
                ItemStack var3 = this.cargoItems[par1];
                this.cargoItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.cargoItems[par1].splitStack(par2);
            if (this.cargoItems[par1].stackSize == 0) {
                this.cargoItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int par1) {
        if (this.cargoItems[par1] != null) {
            ItemStack var2 = this.cargoItems[par1];
            this.cargoItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void setInventorySlotContents(int par1, ItemStack par2ItemStack) {
        this.cargoItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.stackSize > this.getInventoryStackLimit()) {
            par2ItemStack.stackSize = this.getInventoryStackLimit();
        }
    }

    public String getInvName() {
        return "container.minecart";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
    }

    public boolean interact(EntityPlayer player) {
        if (player.isSneaking()) {
            this.entityFollowing = this.entityFollowing == null ? player : null;
            return true;
        }
        if (this.canBeRidden()) {
            if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityPlayer && this.riddenByEntity != player) {
                return true;
            }
            if (!this.worldObj.isRemote) {
                player.mountEntity((Entity)this);
            }
        } else if (this.getSizeInventory() > 0) {
            if (!this.worldObj.isRemote) {
                player.displayGUIChest((IInventory)this);
            }
        } else if (this.pullcartType == 2 && ((Object)((Object)this)).getClass() == CartEntity.class) {
            ItemStack var2 = player.inventory.getCurrentItem();
            if (var2 != null && var2.getItem() == Items.coal) {
                if (--var2.stackSize == 0) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, (ItemStack)null);
                }
                this.fuel += 3600;
            }
            this.pushX = this.posX - player.posX;
            this.pushZ = this.posZ - player.posZ;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.minecartX = par1;
        this.minecartY = par3;
        this.minecartZ = par5;
        this.minecartYaw = par7;
        this.minecartPitch = par8;
        this.turnProgress = par9 + 2;
        this.motionX = this.velocityX;
        this.motionY = this.velocityY;
        this.motionZ = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double par1, double par3, double par5) {
        this.velocityX = this.motionX = par1;
        this.velocityY = this.motionY = par3;
        this.velocityZ = this.motionZ = par5;
    }

    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.isDead ? false : par1EntityPlayer.getDistanceSqToEntity((Entity)this) <= 64.0;
    }

    public boolean isMinecartPowered() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    protected void setMinecartPowered(boolean par1) {
        if (par1) {
            this.dataWatcher.updateObject(16, (Object)((byte)(this.dataWatcher.getWatchableObjectByte(16) | 1)));
        } else {
            this.dataWatcher.updateObject(16, (Object)((byte)(this.dataWatcher.getWatchableObjectByte(16) & 0xFFFFFFFE)));
        }
    }

    public void openChest() {
    }

    public void closeChest() {
    }

    public void setDamage(int par1) {
        this.dataWatcher.updateObject(19, (Object)par1);
    }

    public int getDamage() {
        return this.dataWatcher.getWatchableObjectInt(19);
    }

    public void setRollingAmplitude(int par1) {
        this.dataWatcher.updateObject(17, (Object)par1);
    }

    public int getRollingAmplitude() {
        return this.dataWatcher.getWatchableObjectInt(17);
    }

    public void setRollingDirection(int par1) {
        this.dataWatcher.updateObject(18, (Object)par1);
    }

    public int getRollingDirection() {
        return this.dataWatcher.getWatchableObjectInt(18);
    }

    public void dropCartAsItem() {
        for (ItemStack item : this.getItemsDropped()) {
            this.entityDropItem(item, 0.0f);
        }
    }

    public List<ItemStack> getItemsDropped() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack getCartItem() {
        return null;
    }

    public boolean isPoweredCart() {
        return this.pullcartType == 2 && ((Object)((Object)this)).getClass() == CartEntity.class;
    }

    public boolean isStorageCart() {
        return this.pullcartType == 1 && ((Object)((Object)this)).getClass() == CartEntity.class;
    }

    public boolean canBeRidden() {
        return this.pullcartType == 0 && ((Object)((Object)this)).getClass() == CartEntity.class;
    }

    public boolean canUseRail() {
        return false;
    }

    public void setCanUseRail(boolean use) {
        this.canUseRail = use;
    }

    public boolean shouldDoRailFunctions() {
        return true;
    }

    public int getCartType() {
        return this.pullcartType;
    }

    protected double getDrag() {
        return this.riddenByEntity != null ? defaultDragRidden : defaultDragEmpty;
    }

    protected void applyDragAndPushForces() {
        if (this.isPoweredCart()) {
            double d27 = MathHelper.sqrt_double((double)(this.pushX * this.pushX + this.pushZ * this.pushZ));
            if (d27 > 0.01) {
                this.pushX /= d27;
                this.pushZ /= d27;
                double d29 = 0.04;
                this.motionX *= 0.8;
                this.motionY *= 0.0;
                this.motionZ *= 0.8;
                this.motionX += this.pushX * d29;
                this.motionZ += this.pushZ * d29;
            } else {
                this.motionX *= 0.9;
                this.motionY *= 0.0;
                this.motionZ *= 0.9;
            }
        }
        this.motionX *= this.getDrag();
        this.motionY *= 0.0;
        this.motionZ *= this.getDrag();
    }

    protected void updatePushForces() {
        double push;
        if (this.isPoweredCart() && (push = (double)MathHelper.sqrt_double((double)(this.pushX * this.pushX + this.pushZ * this.pushZ))) > 0.01 && this.motionX * this.motionX + this.motionZ * this.motionZ > 0.001) {
            this.pushX /= push;
            this.pushZ /= push;
            if (this.pushX * this.motionX + this.pushZ * this.motionZ < 0.0) {
                this.pushX = 0.0;
                this.pushZ = 0.0;
            } else {
                this.pushX = this.motionX;
                this.pushZ = this.motionZ;
            }
        }
    }

    protected void moveMinecartOffRail(int i, int j, int k) {
        double d2 = this.getMaxSpeedGround();
        if (!this.onGround) {
            d2 = this.getMaxSpeedAirLateral();
        }
        if (this.motionX < -d2) {
            this.motionX = -d2;
        }
        if (this.motionX > d2) {
            this.motionX = d2;
        }
        if (this.motionZ < -d2) {
            this.motionZ = -d2;
        }
        if (this.motionZ > d2) {
            this.motionZ = d2;
        }
        double moveY = this.motionY;
        if (this.getMaxSpeedAirVertical() > 0.0f && this.motionY > (double)this.getMaxSpeedAirVertical()) {
            moveY = this.getMaxSpeedAirVertical();
            if (Math.abs(this.motionX) < (double)0.3f && Math.abs(this.motionZ) < (double)0.3f) {
                this.motionY = moveY = (double)0.15f;
            }
        }
        if (this.onGround) {
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
        }
        this.moveEntity(this.motionX, moveY, this.motionZ);
        if (!this.onGround) {
            this.motionX *= this.getDragAir();
            this.motionY *= this.getDragAir();
            this.motionZ *= this.getDragAir();
        }
    }

    protected void updateFuel() {
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (this.fuel <= 0) {
            this.pushZ = 0.0;
            this.pushX = 0.0;
        }
        this.setMinecartPowered(this.fuel > 0);
    }

    protected void adjustSlopeVelocities(int metadata) {
        double acceleration = 0.0078125;
        if (metadata == 2) {
            this.motionX -= acceleration;
        } else if (metadata == 3) {
            this.motionX += acceleration;
        } else if (metadata == 4) {
            this.motionZ += acceleration;
        } else if (metadata == 5) {
            this.motionZ -= acceleration;
        }
    }

    public float getMaxSpeedRail() {
        return this.maxSpeedRail;
    }

    public void setMaxSpeedRail(float value) {
        this.maxSpeedRail = value;
    }

    public float getMaxSpeedGround() {
        return this.maxSpeedGround;
    }

    public void setMaxSpeedGround(float value) {
        this.maxSpeedGround = value;
    }

    public float getMaxSpeedAirLateral() {
        return this.maxSpeedAirLateral;
    }

    public void setMaxSpeedAirLateral(float value) {
        this.maxSpeedAirLateral = value;
    }

    public float getMaxSpeedAirVertical() {
        return this.maxSpeedAirVertical;
    }

    public void setMaxSpeedAirVertical(float value) {
        this.maxSpeedAirVertical = value;
    }

    public double getDragAir() {
        return this.dragAir;
    }

    public void setDragAir(double value) {
        this.dragAir = value;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.pullcartType);
    }

    public void readSpawnData(ByteBuf data) {
        this.pullcartType = data.readInt();
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    public String getInventoryName() {
        return null;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }
}

