/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import tconstruct.world.entity.BlueSlime;

public class MetalSlime
extends BlueSlime {
    public MetalSlime(World world) {
        super(world);
        this.setHealth(this.getMaxHealthForSize());
    }

    public boolean attackEntityFrom(DamageSource damageSource, int damage) {
        if (!damageSource.isExplosion() && damageSource.isProjectile()) {
            return false;
        }
        return super.attackEntityFrom(damageSource, (float)damage);
    }

    @Override
    protected float getMaxHealthForSize() {
        int i = this.getSlimeSize();
        if (i == 1) {
            return 4.0f;
        }
        return Math.min(i * i + 20, 100);
    }

    public int getTotalArmorValue() {
        return super.getTotalArmorValue() + 12;
    }

    @Override
    public void setDead() {
        this.isDead = true;
    }

    @Override
    protected void updateEntityActionState() {
        this.despawnEntity();
        EntityPlayer entityplayer = this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, 16.0);
        if (entityplayer != null) {
            this.faceEntity((Entity)entityplayer, 10.0f, 20.0f);
        } else if (this.onGround && this.slimeJumpDelay == 1) {
            this.rotationYaw = this.rotationYaw + this.rand.nextFloat() * 180.0f - 90.0f;
            if (this.rotationYaw > 360.0f) {
                this.rotationYaw -= 360.0f;
            }
            if (this.rotationYaw < 0.0f) {
                this.rotationYaw += 360.0f;
            }
        }
        if (this.onGround && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.getJumpDelay();
            if (entityplayer != null) {
                this.slimeJumpDelay /= 3;
            }
            this.isJumping = true;
            if (this.makesSoundOnJump()) {
                this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.moveStrafing = 1.0f - this.rand.nextFloat() * 2.0f;
            this.moveForward = 1 * this.getSlimeSize();
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.moveForward = 0.0f;
                this.moveStrafing = 0.0f;
            }
        }
    }
}

