/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.model;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import tconstruct.util.ItemHelper;

public class SlimeChannelRender
implements ISimpleBlockRenderingHandler {
    public static int model = RenderingRegistry.getNextAvailableRenderId();
    static final float LIGHT_Y_NEG = 0.5f;
    static final float LIGHT_Y_POS = 1.0f;
    static final float LIGHT_XZ_NEG = 0.8f;
    static final float LIGHT_XZ_POS = 0.6f;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (modelID == model) {
            ItemHelper.renderStandardInvBlock(renderer, block, metadata);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == model) {
            this.renderRotatedBlock(block, x, y, z, world, renderer);
            return true;
        }
        return false;
    }

    public boolean renderRotatedBlock(Block block, int x, int y, int z, IBlockAccess world, RenderBlocks renderer) {
        double v3;
        double u3;
        double v4;
        double u4;
        double v1;
        double u1;
        double v2;
        double u2;
        Tessellator tessellator = Tessellator.instance;
        int bMeta = world.getBlockMetadata(x, y, z);
        IIcon iconStill = block.getIcon(1, bMeta);
        float flowDir = (float)((double)((float)bMeta / 8.0f * 2.0f) * Math.PI);
        if (flowDir < -999.0f) {
            u2 = iconStill.getInterpolatedU(0.0);
            v2 = iconStill.getInterpolatedV(0.0);
            u1 = u2;
            v1 = iconStill.getInterpolatedV(16.0);
            u4 = iconStill.getInterpolatedU(16.0);
            v4 = v1;
            u3 = u4;
            v3 = v2;
        } else {
            float xFlow = MathHelper.sin((float)flowDir) * 0.25f;
            float zFlow = MathHelper.cos((float)flowDir) * 0.25f;
            u2 = iconStill.getInterpolatedU((double)(8.0f + (-zFlow - xFlow) * 16.0f));
            v2 = iconStill.getInterpolatedV((double)(8.0f + (-zFlow + xFlow) * 16.0f));
            u1 = iconStill.getInterpolatedU((double)(8.0f + (-zFlow + xFlow) * 16.0f));
            v1 = iconStill.getInterpolatedV((double)(8.0f + (zFlow + xFlow) * 16.0f));
            u4 = iconStill.getInterpolatedU((double)(8.0f + (zFlow + xFlow) * 16.0f));
            v4 = iconStill.getInterpolatedV((double)(8.0f + (zFlow - xFlow) * 16.0f));
            u3 = iconStill.getInterpolatedU((double)(8.0f + (zFlow - xFlow) * 16.0f));
            v3 = iconStill.getInterpolatedV((double)(8.0f + (-zFlow - xFlow) * 16.0f));
        }
        int color = block.colorMultiplier(world, x, y, z);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        tessellator.setBrightness(block.getMixedBrightnessForBlock(world, x, y, z));
        tessellator.setColorOpaque_F(1.0f * red, 1.0f * green, 1.0f * blue);
        tessellator.addVertexWithUV((double)(x + 0), (double)y + 0.5, (double)(z + 0), u2, v2);
        tessellator.addVertexWithUV((double)(x + 0), (double)y + 0.5, (double)(z + 1), u1, v1);
        tessellator.addVertexWithUV((double)(x + 1), (double)y + 0.5, (double)(z + 1), u4, v4);
        tessellator.addVertexWithUV((double)(x + 1), (double)y + 0.5, (double)(z + 0), u3, v3);
        renderer.renderStandardBlock(block, x, y, z);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelID) {
        return true;
    }

    public int getRenderId() {
        return model;
    }
}

