/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.TFGenericPacketHandler;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.BlockTFPortal;
import twilightforest.block.TFBlocks;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.WorldProviderTwilightForest;

public class TFTickHandler {
    public Item portalItem = null;

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.worldObj;
        if (!TwilightForestMod.disablePortalCreation && event.phase == TickEvent.Phase.END && !world.isRemote && world.getWorldTime() % 20L == 0L) {
            if (TwilightForestMod.adminOnlyPortals) {
                try {
                    if (MinecraftServer.getServer().getConfigurationManager().func_152596_g(player.getGameProfile())) {
                        this.checkForPortalCreation(player, world, 4.0f);
                    }
                }
                catch (NoSuchMethodError ex) {
                    FMLLog.warning((String)"[TwilightForest] Could not determine op status for adminOnlyPortals option, ignoring option.", (Object[])new Object[0]);
                    TwilightForestMod.adminOnlyPortals = false;
                }
            } else {
                this.checkForPortalCreation(player, world, 32.0f);
            }
        }
        if (!world.isRemote && event.phase == TickEvent.Phase.END && world.getWorldTime() % 20L == 0L && world.getGameRules().getGameRuleBooleanValue("tfEnforcedProgression") && world.provider instanceof WorldProviderTwilightForest && !player.capabilities.isCreativeMode) {
            this.checkBiomeForProgression(player, world);
        }
        if (!world.isRemote && event.phase == TickEvent.Phase.END && world.getWorldTime() % 100L == 0L && world.getGameRules().getGameRuleBooleanValue("tfEnforcedProgression") && world.provider instanceof WorldProviderTwilightForest) {
            if (!player.capabilities.isCreativeMode) {
                this.checkForLockedStructuresSendPacket(player, world);
            } else {
                this.sendAllClearPacket(world, player);
            }
        }
    }

    private void sendStructureProtectionPacket(World world, EntityPlayer player, StructureBoundingBox sbb) {
        FMLProxyPacket message = TFGenericPacketHandler.makeStructureProtectionPacket(sbb);
        if (player instanceof EntityPlayerMP) {
            TwilightForestMod.genericChannel.sendTo(message, (EntityPlayerMP)player);
        }
    }

    private void sendAllClearPacket(World world, EntityPlayer player) {
        FMLProxyPacket message = TFGenericPacketHandler.makeStructureProtectionClearPacket();
        if (player instanceof EntityPlayerMP) {
            TwilightForestMod.genericChannel.sendTo(message, (EntityPlayerMP)player);
        }
    }

    private boolean checkForLockedStructuresSendPacket(EntityPlayer player, World world) {
        ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)world.provider).getChunkProvider();
        int px = MathHelper.floor_double((double)player.posX);
        int py = MathHelper.floor_double((double)player.posY);
        int pz = MathHelper.floor_double((double)player.posZ);
        if (chunkProvider != null && chunkProvider.isBlockNearFullStructure(px, pz, 100)) {
            StructureBoundingBox fullSBB = chunkProvider.getFullSBBNear(px, pz, 100);
            TFFeature nearFeature = TFFeature.getFeatureForRegion(fullSBB.getCenterX() >> 4, fullSBB.getCenterZ() >> 4, world);
            if (!nearFeature.hasProtectionAura || nearFeature.doesPlayerHaveRequiredAchievement(player)) {
                this.sendAllClearPacket(world, player);
                return false;
            }
            this.sendStructureProtectionPacket(world, player, fullSBB);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void tickStart(ItemTossEvent event) {
        System.out.println("ItemTossEvent Tick");
    }

    private void checkForPortalCreation(EntityPlayer player, World world, float rangeToCheck) {
        if (world != null && player != null && (world.provider.dimensionId == 0 || world.provider.dimensionId == TwilightForestMod.dimensionID || TwilightForestMod.allowPortalsInOtherDimensions)) {
            List itemList = world.getEntitiesWithinAABB(EntityItem.class, player.boundingBox.expand((double)rangeToCheck, (double)rangeToCheck, (double)rangeToCheck));
            if (this.portalItem == null) {
                // empty if block
            }
            for (EntityItem entityItem : itemList) {
                int dz;
                int dy;
                if (entityItem.getEntityItem().getItem() != this.portalItem || !world.isMaterialInBB(entityItem.boundingBox, Material.water)) continue;
                Random rand = new Random();
                for (int k = 0; k < 2; ++k) {
                    double d = rand.nextGaussian() * 0.02;
                    double d1 = rand.nextGaussian() * 0.02;
                    double d2 = rand.nextGaussian() * 0.02;
                    world.spawnParticle("spell", entityItem.posX, entityItem.posY + 0.2, entityItem.posZ, d, d1, d2);
                }
                int dx = MathHelper.floor_double((double)entityItem.posX);
                if (!((BlockTFPortal)TFBlocks.portal).tryToCreatePortal(world, dx, dy = MathHelper.floor_double((double)entityItem.posY), dz = MathHelper.floor_double((double)entityItem.posZ))) continue;
                player.triggerAchievement((StatBase)TFAchievementPage.twilightPortal);
            }
        }
    }

    private void checkBiomeForProgression(EntityPlayer player, World world) {
        BiomeGenBase currentBiome = world.getBiomeGenForCoords(MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)player.posZ));
        if (currentBiome instanceof TFBiomeBase) {
            boolean dangerousBiome;
            TFBiomeBase tfBiome = (TFBiomeBase)currentBiome;
            boolean bl = dangerousBiome = !tfBiome.doesPlayerHaveRequiredAchievement(player);
            if (dangerousBiome) {
                tfBiome.enforceProgession(player, world);
            }
        }
    }
}

