/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeClearing;
import twilightforest.biomes.TFBiomeDarkForest;
import twilightforest.biomes.TFBiomeDarkForestCenter;
import twilightforest.biomes.TFBiomeDecorator;
import twilightforest.biomes.TFBiomeDeepMushrooms;
import twilightforest.biomes.TFBiomeEnchantedForest;
import twilightforest.biomes.TFBiomeFinalPlateau;
import twilightforest.biomes.TFBiomeFireSwamp;
import twilightforest.biomes.TFBiomeFireflyForest;
import twilightforest.biomes.TFBiomeGlacier;
import twilightforest.biomes.TFBiomeHighlands;
import twilightforest.biomes.TFBiomeMushrooms;
import twilightforest.biomes.TFBiomeOakSavanna;
import twilightforest.biomes.TFBiomeSnow;
import twilightforest.biomes.TFBiomeStream;
import twilightforest.biomes.TFBiomeSwamp;
import twilightforest.biomes.TFBiomeThornlands;
import twilightforest.biomes.TFBiomeTwilightForest;
import twilightforest.biomes.TFBiomeTwilightForestVariant;
import twilightforest.biomes.TFBiomeTwilightLake;
import twilightforest.entity.EntityTFKobold;
import twilightforest.entity.passive.EntityTFBighorn;
import twilightforest.entity.passive.EntityTFBoar;
import twilightforest.entity.passive.EntityTFBunny;
import twilightforest.entity.passive.EntityTFDeer;
import twilightforest.entity.passive.EntityTFMobileFirefly;
import twilightforest.entity.passive.EntityTFRaven;
import twilightforest.entity.passive.EntityTFSquirrel;
import twilightforest.entity.passive.EntityTFTinyBird;

public abstract class TFBiomeBase
extends BiomeGenBase {
    public static final BiomeGenBase tfLake;
    public static final BiomeGenBase twilightForest;
    public static final BiomeGenBase twilightForest2;
    public static final BiomeGenBase highlands;
    public static final BiomeGenBase mushrooms;
    public static final BiomeGenBase tfSwamp;
    public static final BiomeGenBase stream;
    public static final BiomeGenBase tfSnow;
    public static final BiomeGenBase glacier;
    public static final BiomeGenBase clearing;
    public static final BiomeGenBase oakSavanna;
    public static final BiomeGenBase fireflyForest;
    public static final BiomeGenBase deepMushrooms;
    public static final BiomeGenBase darkForest;
    public static final BiomeGenBase enchantedForest;
    public static final BiomeGenBase fireSwamp;
    public static final BiomeGenBase darkForestCenter;
    public static final BiomeGenBase highlandsCenter;
    public static final BiomeGenBase thornlands;
    protected WorldGenBigMushroom bigMushroomGen = new WorldGenBigMushroom();
    protected WorldGenForest birchGen = new WorldGenForest(false, false);
    protected List<BiomeGenBase.SpawnListEntry> undergroundMonsterList;

    public TFBiomeBase(int i) {
        super(i);
        this.worldGeneratorBigTree = null;
        this.spawnableMonsterList.clear();
        this.spawnableWaterCreatureList.clear();
        this.spawnableCreatureList.clear();
        this.spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityTFBighorn.class, 12, 4, 4));
        this.spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityTFBoar.class, 10, 4, 4));
        this.spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityChicken.class, 10, 4, 4));
        this.spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityTFDeer.class, 15, 4, 5));
        this.spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityWolf.class, 5, 4, 4));
        this.spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityTFTinyBird.class, 15, 4, 8));
        this.spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityTFSquirrel.class, 10, 2, 4));
        this.spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityTFBunny.class, 10, 4, 5));
        this.spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityTFRaven.class, 10, 1, 2));
        this.undergroundMonsterList = new ArrayList<BiomeGenBase.SpawnListEntry>();
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntitySpider.class, 10, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityZombie.class, 10, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntitySkeleton.class, 10, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityCreeper.class, 1, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntitySlime.class, 10, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 1, 1, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityTFKobold.class, 10, 4, 8));
        this.spawnableCaveCreatureList.clear();
        this.spawnableCaveCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityBat.class, 10, 8, 8));
        this.spawnableCaveCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityTFMobileFirefly.class, 10, 8, 8));
        this.getTFBiomeDecorator().setTreesPerChunk(10);
        this.getTFBiomeDecorator().setGrassPerChunk(2);
    }

    public TFBiomeBase setColor(int par1) {
        return (TFBiomeBase)super.setColor(par1);
    }

    public float getSpawningChance() {
        return 0.12f;
    }

    public BiomeDecorator createBiomeDecorator() {
        return new TFBiomeDecorator();
    }

    protected TFBiomeDecorator getTFBiomeDecorator() {
        return (TFBiomeDecorator)this.theBiomeDecorator;
    }

    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(5) == 0) {
            return this.birchGen;
        }
        if (random.nextInt(10) == 0) {
            return new WorldGenBigTree(false);
        }
        return this.worldGeneratorTrees;
    }

    public WorldGenerator getRandomWorldGenForGrass(Random par1Random) {
        if (par1Random.nextInt(4) == 0) {
            return new WorldGenTallGrass((Block)Blocks.tallgrass, 2);
        }
        return new WorldGenTallGrass((Block)Blocks.tallgrass, 1);
    }

    public static boolean assignBlankBiomeIds() {
        boolean assigned = false;
        boolean[] usedIDs = new boolean[BiomeGenBase.getBiomeGenArray().length];
        TFBiomeBase.checkUsedIDs(usedIDs);
        TwilightForestMod.idBiomeLake = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeLake);
        TwilightForestMod.idBiomeTwilightForest = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeTwilightForest);
        TwilightForestMod.idBiomeTwilightForestVariant = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeTwilightForestVariant);
        TwilightForestMod.idBiomeHighlands = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeHighlands);
        TwilightForestMod.idBiomeMushrooms = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeMushrooms);
        TwilightForestMod.idBiomeSwamp = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeSwamp);
        TwilightForestMod.idBiomeStream = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeStream);
        TwilightForestMod.idBiomeSnowfield = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeSnowfield);
        TwilightForestMod.idBiomeGlacier = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeGlacier);
        TwilightForestMod.idBiomeClearing = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeClearing);
        TwilightForestMod.idBiomeOakSavanna = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeOakSavanna);
        TwilightForestMod.idBiomeFireflyForest = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeFireflyForest);
        TwilightForestMod.idBiomeDeepMushrooms = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeDeepMushrooms);
        TwilightForestMod.idBiomeDarkForestCenter = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeDarkForestCenter);
        TwilightForestMod.idBiomeHighlandsCenter = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeHighlandsCenter);
        TwilightForestMod.idBiomeDarkForest = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeDarkForest);
        TwilightForestMod.idBiomeEnchantedForest = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeEnchantedForest);
        TwilightForestMod.idBiomeFireSwamp = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeFireSwamp);
        TwilightForestMod.idBiomeThornlands = TFBiomeBase.assignIdIfNeeded(usedIDs, TwilightForestMod.idBiomeThornlands);
        return assigned;
    }

    private static void checkUsedIDs(boolean[] usedIDs) {
        for (int i = 0; i < usedIDs.length; ++i) {
            usedIDs[i] = BiomeGenBase.getBiomeGenArray()[i] != null;
        }
    }

    private static int assignIdIfNeeded(boolean[] usedIDs, int biomeID) {
        if (biomeID == -1) {
            biomeID = TFBiomeBase.findNextOpenBiomeId(usedIDs);
            TwilightForestMod.hasAssignedBiomeID = true;
        }
        return biomeID;
    }

    private static int findNextOpenBiomeId(boolean[] usedIDs) {
        for (int i = 0; i < 256; ++i) {
            if (usedIDs[i]) continue;
            usedIDs[i] = true;
            return i;
        }
        FMLLog.warning((String)"[TwilightForest] Could not find open biome ID.  Edit the Twilight Forest config to give all biomes unique IDs.", (Object[])new Object[0]);
        return -1;
    }

    public static boolean areThereBiomeIdConflicts() {
        boolean conflict = TwilightForestMod.hasBiomeIdConflicts;
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeLake);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeTwilightForest);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeTwilightForestVariant);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeHighlands);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeMushrooms);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeSwamp);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeStream);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeSnowfield);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeGlacier);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeClearing);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeOakSavanna);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeFireflyForest);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeDeepMushrooms);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeDarkForestCenter);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeHighlandsCenter);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeDarkForest);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeEnchantedForest);
        conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeFireSwamp);
        if (conflict |= TFBiomeBase.isConflictAtBiomeID(TwilightForestMod.idBiomeThornlands)) {
            FMLLog.warning((String)"[TwilightForest] Biome ID conflict detected.  Edit the Twilight Forest config to give all biomes unique IDs.", (Object[])new Object[0]);
        }
        TwilightForestMod.hasBiomeIdConflicts |= conflict;
        return conflict;
    }

    public static boolean isConflictAtBiomeID(int id) {
        BiomeGenBase biomeAt = BiomeGenBase.getBiome((int)id);
        if (biomeAt == null || biomeAt instanceof TFBiomeBase) {
            return false;
        }
        FMLLog.warning((String)"[TwilightForest] Biome ID conflict.  Biome ID %d contains a biome named %s, but Twilight Forest is set to use that ID.", (Object[])new Object[]{id, biomeAt.biomeName});
        return true;
    }

    public static void registerWithBiomeDictionary() {
        BiomeDictionary.registerBiomeType((BiomeGenBase)tfLake, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OCEAN});
        BiomeDictionary.registerBiomeType((BiomeGenBase)twilightForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.registerBiomeType((BiomeGenBase)twilightForest2, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE});
        BiomeDictionary.registerBiomeType((BiomeGenBase)highlands, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.CONIFEROUS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)mushrooms, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM});
        BiomeDictionary.registerBiomeType((BiomeGenBase)tfSwamp, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET});
        BiomeDictionary.registerBiomeType((BiomeGenBase)stream, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER});
        BiomeDictionary.registerBiomeType((BiomeGenBase)tfSnow, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS});
        BiomeDictionary.registerBiomeType((BiomeGenBase)glacier, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.registerBiomeType((BiomeGenBase)clearing, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE});
        BiomeDictionary.registerBiomeType((BiomeGenBase)oakSavanna, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPARSE});
        BiomeDictionary.registerBiomeType((BiomeGenBase)fireflyForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH});
        BiomeDictionary.registerBiomeType((BiomeGenBase)deepMushrooms, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM});
        BiomeDictionary.registerBiomeType((BiomeGenBase)darkForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.registerBiomeType((BiomeGenBase)enchantedForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.registerBiomeType((BiomeGenBase)fireSwamp, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HOT});
        BiomeDictionary.registerBiomeType((BiomeGenBase)darkForestCenter, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.registerBiomeType((BiomeGenBase)highlandsCenter, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MESA, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.registerBiomeType((BiomeGenBase)thornlands, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.WASTELAND});
    }

    public void genTerrainBlocks(World world, Random rand, Block[] blockStorage, byte[] metaStorage, int x, int z, double stoneNoise) {
        this.genTwilightBiomeTerrain(world, rand, blockStorage, metaStorage, x, z, stoneNoise);
    }

    public void genTwilightBiomeTerrain(World world, Random rand, Block[] blockStorage, byte[] metaStorage, int x, int z, double stoneNoise) {
        Block topBlock = this.topBlock;
        byte topMeta = (byte)(this.field_150604_aj & 0xFF);
        Block fillerBlock = this.fillerBlock;
        byte fillerMeta = (byte)(this.field_76754_C & 0xFF);
        int currentFillerDepth = -1;
        int maxFillerDepth = (int)(stoneNoise / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int maskX = x & 0xF;
        int maskZ = z & 0xF;
        int worldHeight = blockStorage.length / 256;
        int seaLevel = 32;
        for (int y = 255; y >= 0; --y) {
            int index = (maskZ * 16 + maskX) * worldHeight + y;
            if (y <= 0 + rand.nextInt(5)) {
                blockStorage[index] = Blocks.bedrock;
                continue;
            }
            Block currentBlock = blockStorage[index];
            if (currentBlock == null || currentBlock.getMaterial() == Material.air || currentBlock != Blocks.stone) continue;
            if (this.getStoneReplacementBlock() != null) {
                blockStorage[index] = this.getStoneReplacementBlock();
                metaStorage[index] = this.getStoneReplacementMeta();
            }
            if (currentFillerDepth == -1) {
                if (maxFillerDepth <= 0) {
                    topBlock = null;
                    topMeta = 0;
                    fillerBlock = Blocks.stone;
                    fillerMeta = 0;
                } else if (y >= seaLevel - 5 && y <= seaLevel) {
                    topBlock = this.topBlock;
                    topMeta = (byte)(this.field_150604_aj & 0xFF);
                    fillerBlock = this.fillerBlock;
                    fillerMeta = (byte)(this.field_76754_C & 0xFF);
                }
                if (y < seaLevel - 1 && (topBlock == null || topBlock.getMaterial() == Material.air)) {
                    if (this.getFloatTemperature(x, y, z) < 0.15f) {
                        topBlock = Blocks.ice;
                        topMeta = 0;
                    } else {
                        topBlock = Blocks.water;
                        topMeta = 0;
                    }
                }
                currentFillerDepth = maxFillerDepth;
                if (y >= seaLevel - 2) {
                    blockStorage[index] = topBlock;
                    metaStorage[index] = topMeta;
                    continue;
                }
                if (y < seaLevel - 8 - maxFillerDepth) {
                    topBlock = null;
                    fillerBlock = Blocks.stone;
                    fillerMeta = 0;
                    blockStorage[index] = Blocks.gravel;
                    continue;
                }
                blockStorage[index] = fillerBlock;
                metaStorage[index] = fillerMeta;
                continue;
            }
            if (currentFillerDepth <= 0) continue;
            blockStorage[index] = fillerBlock;
            metaStorage[index] = fillerMeta;
            if (--currentFillerDepth != 0 || fillerBlock != Blocks.sand) continue;
            currentFillerDepth = rand.nextInt(4) + Math.max(0, y - (seaLevel - 1));
            fillerBlock = Blocks.sandstone;
            fillerMeta = 0;
        }
    }

    public Block getStoneReplacementBlock() {
        return null;
    }

    public byte getStoneReplacementMeta() {
        return 0;
    }

    public boolean doesPlayerHaveRequiredAchievement(EntityPlayer player) {
        if (this.getRequiredAchievement() != null && player instanceof EntityPlayerMP && ((EntityPlayerMP)player).func_147099_x() != null) {
            StatisticsFile stats = ((EntityPlayerMP)player).func_147099_x();
            return stats.hasAchievementUnlocked(this.getRequiredAchievement());
        }
        if (this.getRequiredAchievement() != null && player instanceof EntityClientPlayerMP && ((EntityClientPlayerMP)player).getStatFileWriter() != null) {
            StatFileWriter stats = ((EntityClientPlayerMP)player).getStatFileWriter();
            return stats.hasAchievementUnlocked(this.getRequiredAchievement());
        }
        return true;
    }

    protected Achievement getRequiredAchievement() {
        return null;
    }

    public void enforceProgession(EntityPlayer player, World world) {
    }

    public List<BiomeGenBase.SpawnListEntry> getUndergroundSpawnableList() {
        return this.undergroundMonsterList;
    }

    static {
        TFBiomeBase.assignBlankBiomeIds();
        TFBiomeBase.areThereBiomeIdConflicts();
        tfLake = new TFBiomeTwilightLake(TwilightForestMod.idBiomeLake).setColor(255).setBiomeName("Twilight Lake").setHeight(height_DeepOceans);
        twilightForest = new TFBiomeTwilightForest(TwilightForestMod.idBiomeTwilightForest).setColor(21760).setBiomeName("Twilight Forest");
        twilightForest2 = new TFBiomeTwilightForestVariant(TwilightForestMod.idBiomeTwilightForestVariant).setColor(21794).setBiomeName("Dense Twilight Forest").setHeight(height_MidPlains);
        highlands = new TFBiomeHighlands(TwilightForestMod.idBiomeHighlands).setColor(0x556644).setBiomeName("Twilight Highlands").setHeight(new BiomeGenBase.Height(3.5f, 0.05f));
        mushrooms = new TFBiomeMushrooms(TwilightForestMod.idBiomeMushrooms).setColor(0x226622).setBiomeName("Mushroom Forest");
        tfSwamp = new TFBiomeSwamp(TwilightForestMod.idBiomeSwamp).setColor(0x334422).setBiomeName("Twilight Swamp").setHeight(new BiomeGenBase.Height(-0.125f, 0.125f));
        stream = new TFBiomeStream(TwilightForestMod.idBiomeStream).setColor(3298231).setBiomeName("Twilight Stream").setHeight(height_ShallowWaters);
        tfSnow = new TFBiomeSnow(TwilightForestMod.idBiomeSnowfield).setColor(0xCCFFFF).setBiomeName("Snowy Forest").setHeight(height_MidPlains);
        glacier = new TFBiomeGlacier(TwilightForestMod.idBiomeGlacier).setColor(0x7777BB).setBiomeName("Twilight Glacier");
        clearing = new TFBiomeClearing(TwilightForestMod.idBiomeClearing).setColor(3447604).setBiomeName("Twilight Clearing").setHeight(height_LowPlains);
        oakSavanna = new TFBiomeOakSavanna(TwilightForestMod.idBiomeOakSavanna).setColor(0x446622).setBiomeName("Oak Savanna").setHeight(height_MidPlains);
        fireflyForest = new TFBiomeFireflyForest(TwilightForestMod.idBiomeFireflyForest).setColor(26163).setBiomeName("Firefly Forest").setHeight(height_LowPlains);
        deepMushrooms = new TFBiomeDeepMushrooms(TwilightForestMod.idBiomeDeepMushrooms).setColor(0x663322).setBiomeName("Deep Mushroom Forest").setHeight(height_LowPlains);
        darkForest = new TFBiomeDarkForest(TwilightForestMod.idBiomeDarkForest).setColor(13073).setBiomeName("Dark Forest").setHeight(height_LowPlains);
        enchantedForest = new TFBiomeEnchantedForest(TwilightForestMod.idBiomeEnchantedForest).setColor(0x115566).setBiomeName("Enchanted Forest");
        fireSwamp = new TFBiomeFireSwamp(TwilightForestMod.idBiomeFireSwamp).setColor(4334362).setBiomeName("Fire Swamp").setHeight(height_Default);
        darkForestCenter = new TFBiomeDarkForestCenter(TwilightForestMod.idBiomeDarkForestCenter).setColor(8704).setBiomeName("Dark Forest Center").setHeight(height_LowPlains);
        highlandsCenter = new TFBiomeFinalPlateau(TwilightForestMod.idBiomeHighlandsCenter).setColor(0x334422).setBiomeName("Highlands Center").setHeight(new BiomeGenBase.Height(10.5f, 0.025f));
        thornlands = new TFBiomeThornlands(TwilightForestMod.idBiomeThornlands).setColor(0x223322).setBiomeName("Thornlands").setHeight(new BiomeGenBase.Height(6.0f, 0.1f));
    }
}

