/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.stats.Achievement;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.biomes.TFBiomeDecorator;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFTroll;
import twilightforest.world.TFGenTrollRoots;

public class TFBiomeHighlands
extends TFBiomeBase {
    private static final WorldGenTaiga1 taigaGen1 = new WorldGenTaiga1();
    private static final WorldGenTaiga2 taigaGen2 = new WorldGenTaiga2(false);
    private static final WorldGenMegaPineTree megaPineGen1 = new WorldGenMegaPineTree(false, false);
    private static final WorldGenMegaPineTree megaPineGen2 = new WorldGenMegaPineTree(false, true);
    private static final WorldGenBlockBlob genBoulder = new WorldGenBlockBlob(Blocks.mossy_cobblestone, 0);
    private static final TFGenTrollRoots genTrollRoots = new TFGenTrollRoots();
    private static final WorldGenTallGrass worldGenMushgloom = new WorldGenTallGrass(TFBlocks.plant, 9);

    public TFBiomeHighlands(int i) {
        super(i);
        this.temperature = 0.4f;
        this.rainfall = 0.7f;
        ((TFBiomeDecorator)this.theBiomeDecorator).canopyPerChunk = -999.0f;
        this.theBiomeDecorator.grassPerChunk = 7;
        this.theBiomeDecorator.deadBushPerChunk = 1;
        this.theBiomeDecorator.generateLakes = false;
        this.undergroundMonsterList.clear();
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntitySkeleton.class, 10, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityCreeper.class, 1, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntitySlime.class, 10, 4, 4));
        this.undergroundMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityTFTroll.class, 10, 4, 4));
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(4) == 0) {
            return taigaGen1;
        }
        if (random.nextInt(10) == 0) {
            return taigaGen2;
        }
        if (random.nextInt(3) == 0) {
            return megaPineGen1;
        }
        if (random.nextInt(13) == 0) {
            return megaPineGen2;
        }
        return this.birchGen;
    }

    @Override
    public WorldGenerator getRandomWorldGenForGrass(Random random) {
        return random.nextInt(5) > 0 ? new WorldGenTallGrass((Block)Blocks.tallgrass, 2) : new WorldGenTallGrass((Block)Blocks.tallgrass, 1);
    }

    @Override
    public void genTerrainBlocks(World world, Random rand, Block[] blockStorage, byte[] metaStorage, int x, int z, double noiseVal) {
        this.topBlock = Blocks.grass;
        this.field_150604_aj = 0;
        this.fillerBlock = Blocks.dirt;
        if (noiseVal > 1.75) {
            this.topBlock = Blocks.dirt;
            this.field_150604_aj = 1;
        } else if (noiseVal > -0.95) {
            this.topBlock = Blocks.dirt;
            this.field_150604_aj = 2;
        }
        this.genTwilightBiomeTerrain(world, rand, blockStorage, metaStorage, x, z, noiseVal);
    }

    public void decorate(World world, Random random, int mapX, int mapZ) {
        int rx;
        int dy;
        int dz;
        int dx;
        int i;
        int maxBoulders = random.nextInt(2);
        for (i = 0; i < maxBoulders; ++i) {
            dx = mapX + random.nextInt(16) + 8;
            dz = mapZ + random.nextInt(16) + 8;
            dy = world.getHeightValue(dx, dz);
            genBoulder.generate(world, random, dx, dy, dz);
        }
        genTallFlowers.func_150548_a(3);
        for (i = 0; i < 7; ++i) {
            dx = mapX + random.nextInt(16) + 8;
            dz = mapZ + random.nextInt(16) + 8;
            dy = random.nextInt(world.getHeightValue(dx, dz) + 32);
            genTallFlowers.generate(world, random, dx, dy, dz);
        }
        for (i = 0; i < 1; ++i) {
            rx = mapX + random.nextInt(16) + 8;
            int rz = mapZ + random.nextInt(16) + 8;
            int ry = random.nextInt(64);
            worldGenMushgloom.generate(world, random, rx, ry, rz);
        }
        for (i = 0; i < 24; ++i) {
            rx = mapX + random.nextInt(16) + 8;
            int ry = 64;
            int rz = mapZ + random.nextInt(16) + 8;
            genTrollRoots.generate(world, random, rx, ry, rz);
        }
        super.decorate(world, random, mapX, mapZ);
    }

    public String func_150572_a(Random rand, int x, int y, int z) {
        return rand.nextBoolean() ? BlockFlower.field_149858_b[0] : BlockFlower.field_149859_a[8];
    }

    @Override
    protected Achievement getRequiredAchievement() {
        return TFAchievementPage.twilightProgressGlacier;
    }

    @Override
    public void enforceProgession(EntityPlayer player, World world) {
        if (!world.isRemote && world.getWorldTime() % 5L == 0L) {
            player.attackEntityFrom(DamageSource.magic, 0.5f);
            world.playSoundAtEntity((Entity)player, "random.fizz", 1.0f, 1.0f);
            if (world.rand.nextInt(4) == 0) {
                TFFeature.trollCave.trySpawnHintMonster(world, player);
            }
        }
    }
}

