/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import twilightforest.block.BlockTFGiantBlock;
import twilightforest.item.TFItems;

public class BlockTFGiantLeaves
extends BlockTFGiantBlock {
    public BlockTFGiantLeaves() {
        super((Block)Blocks.leaves);
        this.setHardness(12.8f);
        this.setLightOpacity(1);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBlockColor() {
        double d0 = 0.5;
        double d1 = 1.0;
        return ColorizerFoliage.getFoliageColor((double)d0, (double)d1);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(int p_149741_1_) {
        return ColorizerFoliage.getFoliageColorBasic();
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess world, int x, int y, int z) {
        int red = 0;
        int grn = 0;
        int blu = 0;
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                int nearbyColor = world.getBiomeGenForCoords(x + dx, z + dz).getBiomeFoliageColor(x + dx, y, z + dz);
                red += (nearbyColor & 0xFF0000) >> 16;
                grn += (nearbyColor & 0xFF00) >> 8;
                blu += nearbyColor & 0xFF;
            }
        }
        return (red / 9 & 0xFF) << 16 | (grn / 9 & 0xFF) << 8 | blu / 9 & 0xFF;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                return (y & 3) == 3;
            }
            case 1: {
                return (y & 3) == 0;
            }
            case 2: {
                return (z & 3) == 3;
            }
            case 3: {
                return (z & 3) == 0;
            }
            case 4: {
                return (x & 3) == 3;
            }
            case 5: {
                return (x & 3) == 0;
            }
        }
        return super.shouldSideBeRendered(world, x, y, z, side);
    }
}

